/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.security;

import com.atlassian.fecru.security.SshKeySupplier;
import com.atlassian.fisheye.spi.admin.data.KeyPair;
import com.atlassian.security.random.SecureRandomFactory;
import com.cenqua.fisheye.FishEyeSysProps;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.util.encoders.Base64;

public class SshKeySupplierImpl
implements SshKeySupplier {
    private RSAKeyPairGenerator rsaKeyPairGenerator;
    private KeyFactory rsaKeyFactory;

    public KeyPair get() {
        try {
            return this.doGenerateKeyPair();
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    private synchronized RSAKeyPairGenerator getRsaKeyPairGenerator() {
        if (this.rsaKeyPairGenerator == null) {
            this.rsaKeyPairGenerator = new RSAKeyPairGenerator();
            this.rsaKeyPairGenerator.init((KeyGenerationParameters)new RSAKeyGenerationParameters(new BigInteger("10001", 16), SecureRandomFactory.newInstance(), FishEyeSysProps.SSH_KEYSIZE, 80));
        }
        return this.rsaKeyPairGenerator;
    }

    private synchronized KeyFactory getKeyFactory() throws NoSuchAlgorithmException {
        if (this.rsaKeyFactory == null) {
            this.rsaKeyFactory = KeyFactory.getInstance("RSA");
        }
        return this.rsaKeyFactory;
    }

    private String getRsaPublicKeyAsPKCS(RSAPublicKey rsaPublicKey) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(output);
        dos.writeInt("ssh-rsa".getBytes().length);
        dos.write("ssh-rsa".getBytes());
        dos.writeInt(rsaPublicKey.getPublicExponent().toByteArray().length);
        dos.write(rsaPublicKey.getPublicExponent().toByteArray());
        dos.writeInt(rsaPublicKey.getModulus().toByteArray().length);
        dos.write(rsaPublicKey.getModulus().toByteArray());
        String enc = new String(Base64.encode((byte[])output.toByteArray()));
        dos.write(enc.getBytes());
        return "ssh-rsa " + enc;
    }

    private String getObjectAsPEM(Object o2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)stringWriter);
        pemWriter.writeObject(o2);
        pemWriter.flush();
        pemWriter.close();
        return stringWriter.toString();
    }

    KeyPair doGenerateKeyPair() throws InvalidKeySpecException, IOException, NoSuchAlgorithmException {
        AsymmetricCipherKeyPair kp = this.getRsaKeyPairGenerator().generateKeyPair();
        RSAPrivateCrtKeyParameters rsapckp = (RSAPrivateCrtKeyParameters)kp.getPrivate();
        RSAKeyParameters rsakp = (RSAKeyParameters)kp.getPublic();
        RSAPrivateCrtKeySpec prvKeySpecs = new RSAPrivateCrtKeySpec(rsapckp.getModulus(), rsapckp.getPublicExponent(), rsapckp.getExponent(), rsapckp.getP(), rsapckp.getQ(), rsapckp.getDP(), rsapckp.getDQ(), rsapckp.getQInv());
        PrivateKey privateKey = this.getKeyFactory().generatePrivate(prvKeySpecs);
        String privateKeyPEM = this.getObjectAsPEM(privateKey);
        RSAPublicKeySpec pubKeySpecs = new RSAPublicKeySpec(rsakp.getModulus(), rsakp.getExponent());
        PublicKey publicKey = this.getKeyFactory().generatePublic(pubKeySpecs);
        RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
        String pkcsPublicKey = this.getRsaPublicKeyAsPKCS(rsaPublicKey);
        return new KeyPair(pkcsPublicKey, privateKeyPEM);
    }
}

