/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.security;

import com.atlassian.fecru.security.SshKeySupplier;
import com.atlassian.fecru.security.SshKeySupplierImpl;
import com.atlassian.fecru.util.PreGeneratedPoolSupplier;
import com.atlassian.fisheye.spi.admin.data.KeyPair;
import com.cenqua.fisheye.FishEyeSysProps;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SshKeyPoolSupplierImpl
implements SshKeySupplier {
    public static final int GET_TIMEOUT_SECS = 300;
    private final StartableSshKeySupplier keySupplier;

    @Autowired
    public SshKeyPoolSupplierImpl(@Qualifier(value="sshKeyPoolExecutor") ExecutorService executorService) {
        this(new SshKeySupplierImpl(), executorService);
    }

    SshKeyPoolSupplierImpl(SshKeySupplier keySupplier, ExecutorService executorService) {
        this.keySupplier = FishEyeSysProps.SSH_KEYPOOL_SIZE <= 0 ? new SimpleStartableSshKeySupplier(keySupplier) : new PoolStartableSshKeySupplier(new PreGeneratedPoolSupplier<KeyPair>(keySupplier, FishEyeSysProps.SSH_KEYPOOL_SIZE, 300, executorService));
    }

    public KeyPair get() {
        return (KeyPair)this.keySupplier.get();
    }

    @PostConstruct
    public void created() {
        this.keySupplier.start();
    }

    private static class PoolStartableSshKeySupplier
    implements StartableSshKeySupplier {
        private final PreGeneratedPoolSupplier<KeyPair> sshKeySupplier;

        PoolStartableSshKeySupplier(PreGeneratedPoolSupplier<KeyPair> sshKeySupplier) {
            this.sshKeySupplier = sshKeySupplier;
        }

        @Override
        public void start() {
            this.sshKeySupplier.triggerRefill();
        }

        public KeyPair get() {
            return this.sshKeySupplier.get();
        }
    }

    private static class SimpleStartableSshKeySupplier
    implements StartableSshKeySupplier {
        private final SshKeySupplier sshKeySupplier;

        SimpleStartableSshKeySupplier(SshKeySupplier sshKeySupplier) {
            this.sshKeySupplier = sshKeySupplier;
        }

        @Override
        public void start() {
        }

        public KeyPair get() {
            return (KeyPair)this.sshKeySupplier.get();
        }
    }

    private static interface StartableSshKeySupplier
    extends SshKeySupplier {
        public void start();
    }
}

