/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.security;

import com.atlassian.fecru.security.SshKey;
import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fecru.security.SshKeySupplier;
import com.atlassian.fisheye.spi.admin.data.KeyPair;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.FileSystemUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="sshKeyManager")
@AvailableToPlugins
public class SshKeyManagerImpl
implements SshKeyManager {
    private final RootConfig rootConfig;
    private final FileSystemUtils fileSystemUtils;
    private final SshKeySupplier keySupplier;
    private String pathToSshExecutable;

    @Autowired
    public SshKeyManagerImpl(RootConfig rootConfig, FileSystemUtils fileSystemUtils, SshKeySupplier keySupplier) {
        this.rootConfig = rootConfig;
        this.fileSystemUtils = fileSystemUtils;
        this.keySupplier = keySupplier;
    }

    @Override
    public String getPrivateKeyPath(String keyname) {
        File privateKey = this.getPrivateKey(keyname);
        if (privateKey == null) {
            return null;
        }
        return privateKey.getAbsolutePath();
    }

    private File getPrivateKey(String keyname) {
        if (keyname == null) {
            return null;
        }
        return new File(this.getAuthDir(), keyname);
    }

    @Override
    public String getPublicKeyContents(String keyname) throws IOException {
        return IOHelper.copyFileToString(Charsets.UTF_8, this.getPublicKey(keyname));
    }

    @Override
    public File getPublicKey(String keyname) {
        return new File(this.getAuthDir(), keyname + ".pub");
    }

    @Override
    public KeyPair generateKeyPair(String keyName) {
        KeyPair key = (KeyPair)this.keySupplier.get();
        String label = keyName + " on FishEye at " + this.rootConfig.getSiteURL();
        return new KeyPair(key.getPublicKey() + " " + label, key.getPrivateKey());
    }

    @Override
    public SshKey generateAndSaveKeyPair(String keyPrefix) throws NoSuchAlgorithmException, IOException, JSchException, InvalidKeySpecException {
        KeyPair keyPair = this.generateKeyPair(keyPrefix);
        return this.saveKeyPair(keyPrefix, keyPair.getPublicKey(), keyPair.getPrivateKey());
    }

    private File createPrivateKeyFile(String keyPrefix) throws IOException {
        String keyName = keyPrefix;
        File privateKey = this.getPrivateKey(keyName);
        while (privateKey.exists()) {
            keyName = keyPrefix + "-" + this.generateStamp();
            privateKey = this.getPrivateKey(keyName);
            Logs.APP_LOG.debug((Object)("Creating private key '" + privateKey.getAbsolutePath() + "' with prefix: '" + keyPrefix + "'."));
        }
        this.createNewFile(privateKey);
        this.fileSystemUtils.privatise(privateKey);
        return privateKey;
    }

    @Override
    public boolean isEncrypted(String privateContents) throws JSchException, IOException {
        SshKey key = this.saveKeyPair("tmp", null, privateContents);
        this.removeKey(key.getName());
        return key.isEncrypted();
    }

    @Override
    public SshKey saveKeyPair(String keyPrefix, String publicContents, String privateContents) throws IOException, JSchException {
        this.ensureDirectoryExistsAndIsPrivate(this.getAuthDir());
        File privateKey = this.createPrivateKeyFile(keyPrefix);
        IOHelper.copyStringToFile(privateContents, Charsets.UTF_8, privateKey);
        if (!Strings.isNullOrEmpty((String)publicContents)) {
            File publicKey = this.getPublicKey(privateKey.getName());
            this.createNewFile(publicKey);
            IOHelper.copyStringToFile(publicContents, Charsets.UTF_8, publicKey);
        }
        JSch jsch = new JSch();
        com.jcraft.jsch.KeyPair kpair = com.jcraft.jsch.KeyPair.load((JSch)jsch, (String)privateKey.getAbsolutePath());
        boolean encrypted = kpair.isEncrypted();
        kpair.dispose();
        return new SshKey(privateKey.getName(), publicContents, encrypted);
    }

    private void createNewFile(File file) throws IOException {
        boolean created = IOHelper.createNewFile(file);
        if (!created) {
            throw new IOException("SSH key '" + file.getAbsolutePath() + "' already exists.");
        }
    }

    @Override
    public boolean removeKey(String keyName) {
        File publicKey;
        boolean result = true;
        File privateKey = this.getPrivateKey(keyName);
        if (privateKey != null && privateKey.exists()) {
            result &= privateKey.delete();
        }
        if ((publicKey = this.getPublicKey(keyName)) != null && publicKey.exists()) {
            result &= publicKey.delete();
        }
        return result;
    }

    private File getAuthDir() {
        return new File(AppConfig.getDataDir(), "auth");
    }

    private File ensureDirectoryExistsAndIsPrivate(File dir) {
        if (!dir.exists()) {
            try {
                IOHelper.mkdirs(dir);
                this.fileSystemUtils.privatise(dir);
            }
            catch (IOException e2) {
                RuntimeException exception = new RuntimeException("Couldn't create directory " + dir.getAbsolutePath());
                exception.initCause(e2);
                throw exception;
            }
        }
        return dir;
    }

    @Override
    public String getPathToSshExecutable() {
        if (this.pathToSshExecutable != null) {
            return this.pathToSshExecutable;
        }
        String errorMsg = "Could not find SSH binary on the system path. See https://confluence.atlassian.com/display/FISHEYE/Authentication";
        try {
            Optional<String> sshExec = this.getSshExecutablePathFromSshExeProperty();
            if (!sshExec.isPresent()) {
                sshExec = this.searchSshExecutableInPath();
            }
            if (sshExec.isPresent()) {
                this.pathToSshExecutable = (String)sshExec.get();
                Logs.APP_LOG.info((Object)("Fisheye is using '" + this.pathToSshExecutable + "' to authenticate with SSH authenticated repositories."));
            } else {
                Logs.APP_LOG.error((Object)"Could not find SSH binary on the system path. See https://confluence.atlassian.com/display/FISHEYE/Authentication");
            }
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Could not find SSH binary on the system path. See https://confluence.atlassian.com/display/FISHEYE/Authentication", (Throwable)e2);
        }
        return this.pathToSshExecutable;
    }

    private Optional<String> getSshExecutablePathFromSshExeProperty() {
        String sshExeProperty = System.getProperty("ssh.exe");
        return Optional.fromNullable((Object)Strings.emptyToNull((String)sshExeProperty));
    }

    private Optional<String> searchSshExecutableInPath() throws IOException {
        File sshExec = this.fileSystemUtils.searchPath("ssh", "ssh.exe");
        return sshExec != null ? Optional.of((Object)sshExec.getCanonicalPath()) : Optional.absent();
    }

    private String generateStamp() {
        long i2 = System.currentTimeMillis();
        return Long.toString(i2, 36).toLowerCase();
    }
}

