/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.security;

import com.atlassian.fecru.security.Credentials;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class SshKeyCredentials
implements Credentials {
    private File privateKey;
    private String passphrase;

    public SshKeyCredentials(File privateKey, String passphrase) {
        this.privateKey = privateKey;
        this.passphrase = passphrase;
    }

    public SshKeyCredentials(File privateKey) {
        this.privateKey = privateKey;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public boolean hasPassphrase() {
        return StringUtils.isNotEmpty((String)this.passphrase);
    }

    public File getPrivateKey() {
        return this.privateKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.passphrase == null ? 0 : this.passphrase.hashCode());
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SshKeyCredentials other = (SshKeyCredentials)obj;
        if (this.passphrase == null ? other.passphrase != null : !this.passphrase.equals(other.passphrase)) {
            return false;
        }
        return !(this.privateKey == null ? other.privateKey != null : !this.privateKey.equals(other.privateKey));
    }
}

