/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.security;

import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.fecru.user.EffectiveUserProvider;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RequirePrivilegedUserAspect {
    @Resource
    private EffectiveUserProvider effectiveUserProvider;

    @Pointcut(value="execution(@com.atlassian.fecru.security.RequirePrivilegedUser * *(..))")
    public void requirePrivilegedUserMethod() {
    }

    @Pointcut(value="within(@com.atlassian.fecru.security.RequirePrivilegedUser *)")
    public void requirePrivilegedUserType() {
    }

    @Before(value="requirePrivilegedUserMethod() || requirePrivilegedUserType()")
    public void beforePrivilegedUserMethods(JoinPoint joinPoint) {
        if (!this.effectiveUserProvider.isAdmin()) {
            throw new NotPermittedException("You must be a privileged user to perform this operation");
        }
    }
}

