/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.security;

import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

@Named(value="currentUserPermissions")
@Scope(value="request", proxyMode=ScopedProxyMode.NO)
public class DefaultCurrentUserPermissions
implements CurrentUserPermissions {
    private final EffectiveUserProvider effectiveUserProvider;
    private final PermissionManager permissionManager;
    private final Cache<CacheKey, Boolean> canModifyReview = CacheBuilder.newBuilder().build();
    private final Cache<CacheKey, Boolean> canCommentReview = CacheBuilder.newBuilder().build();
    private final Cache<CacheKey, Boolean> canViewReview = CacheBuilder.newBuilder().build();

    @Autowired
    public DefaultCurrentUserPermissions(EffectiveUserProvider effectiveUserProvider, PermissionManager permissionManager) {
        this.effectiveUserProvider = effectiveUserProvider;
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean canModifyReview(Review review) {
        try {
            return (Boolean)this.canModifyReview.get((Object)this.keyFor(review), () -> this.canDoReviewAction(review, UserActionManager.ACTION_MOD_FILES));
        }
        catch (ExecutionException e2) {
            throw Throwables.propagate((Throwable)e2);
        }
    }

    @Override
    public boolean canCommentReview(Review review) {
        try {
            return (Boolean)this.canCommentReview.get((Object)this.keyFor(review), () -> this.canDoReviewAction(review, UserActionManager.ACTION_COMMENT));
        }
        catch (ExecutionException e2) {
            throw Throwables.propagate((Throwable)e2);
        }
    }

    @Override
    public boolean canViewReview(Review review) {
        try {
            return (Boolean)this.canViewReview.get((Object)this.keyFor(review), () -> this.canDoReviewAction(review, UserActionManager.ACTION_VIEW));
        }
        catch (ExecutionException e2) {
            throw Throwables.propagate((Throwable)e2);
        }
    }

    public boolean canDoReviewAction(Review review, String action) {
        return review.isNotClosed() && this.permissionManager.canPrincipalDoAction(review.getProject().getPermissionScheme(), this.effectiveUserProvider.getEffectivePrincipal(), this.effectiveUserProvider.getEffectiveUser(), action, review);
    }

    private CacheKey keyFor(Review review) {
        return new CacheKey(this.effectiveUserProvider.getEffectivePrincipal(), review);
    }

    private static class CacheKey {
        private final Principal principal;
        private final Integer reviewId;

        private CacheKey(Principal principal, Review review) {
            this.principal = principal;
            this.reviewId = review.getId();
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o2;
            return Objects.equals(this.principal, cacheKey.principal) && Objects.equals(this.reviewId, cacheKey.reviewId);
        }

        public int hashCode() {
            return Objects.hash(this.principal, this.reviewId);
        }
    }
}

