/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.users;

import com.atlassian.fecru.search.common.api.QuickSearcher;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.CrossRepoSearcher;
import com.atlassian.fecru.search.common.lucene.CrossRepoSearcherState;
import com.atlassian.fecru.search.users.CommitterHighlighter;
import com.atlassian.fecru.search.users.CommitterSearchResult;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.crossrepo.AbstractRepositoryQueryBuilder;
import com.cenqua.fisheye.crossrepo.AuthorDocInfo;
import com.cenqua.fisheye.crossrepo.AuthorQueryBuilder;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.searcher.PayloadIndexSearcher;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommitterSearcher
extends CrossRepoSearcher<CommitterSearchResult>
implements QuickSearcher<CommitterSearchResult> {
    @Autowired
    public CommitterSearcher(RepositoryManager repositoryManager, CrossRepLuceneIndex crossRepLuceneIndex) {
        super(SearchType.COMMITTERS, CrossRepLuceneIndexes.METADATA, repositoryManager, crossRepLuceneIndex);
    }

    @Override
    protected Query generateQuery(String userQuery, PayloadIndexSearcher<CrossRepoSearcherState> searcher, SearchScope scope, CrossRepoSearcherState state) throws IOException {
        return ((AbstractRepositoryQueryBuilder)((AuthorQueryBuilder)AuthorQueryBuilder.newAuthorCrossRepoQueryBuilder().optimalRepositoryQuery(state.getIncludeRepos(), state.getExcludeRepos())).queryByAuthor(userQuery)).build();
    }

    @Override
    protected SearchResults<CommitterSearchResult> buildSearchResults(TopDocs hits, SearchScope scope, PayloadIndexSearcher<CrossRepoSearcherState> searcher, String queryText, Query query) {
        ArrayList results = Lists.newArrayListWithCapacity((int)scope.length());
        for (int i2 = 0; i2 < hits.scoreDocs.length; ++i2) {
            ScoreDoc hit = hits.scoreDocs[i2];
            try {
                if (!scope.inScope(i2)) continue;
                AuthorDocInfo info = AuthorDocInfo.fromSearchHit(searcher, hit);
                String author = info.getAuthor();
                String highlightedName = new CommitterHighlighter(author, query).highlight();
                CommitterSearchResult result = new CommitterSearchResult(info.getRepository(), author, highlightedName);
                results.add(new SearchHit(result, hit.score, null));
                continue;
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)("Could not fetch result from index: doc ID " + hit.doc), (Throwable)e2);
            }
        }
        Collections.sort(results);
        ArrayList r2 = Lists.newArrayListWithCapacity((int)results.size());
        for (SearchHit h2 : results) {
            r2.add(h2.result);
        }
        return new SearchResults<CommitterSearchResult>(hits.totalHits, r2, this.getType());
    }

    private static class SearchHit<T extends Comparable<T>>
    implements Comparable<SearchHit<T>> {
        private final T result;
        private final float score;

        private SearchHit(T result, float score) {
            this.result = result;
            this.score = score;
        }

        @Override
        public int compareTo(SearchHit<T> o2) {
            if (this.score != o2.score) {
                return Float.compare(o2.score, this.score);
            }
            return this.result.compareTo(o2.result);
        }

        /* synthetic */ SearchHit(Comparable x0, float x1, 1 x2) {
            this(x0, x1);
        }
    }
}

