/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.reviews;

import com.atlassian.crucible.wikirenderer.CrucibleRenderContext;
import com.atlassian.fecru.search.common.highlighting.WikiHighlighter;
import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.LinkerService;
import com.cenqua.fisheye.syntax.RepositoryNotFoundException;

final class ReviewWikiHighlighter
extends WikiHighlighter {
    private final LinkerService linkerService;

    public ReviewWikiHighlighter(WikiRenderer wikiRenderer, LinkerService linkerService) {
        super(wikiRenderer);
        this.linkerService = linkerService;
    }

    public String highlight(String text, String queryText, String projectKey, String projectRepoName, Render mode, boolean returnNullIfNoHits) {
        Linker linker = this.getLinker(projectRepoName, projectKey);
        CrucibleRenderContext context = (CrucibleRenderContext)this.wikiRenderer.setupRenderContextProperties((RenderContext)new CrucibleRenderContext(null, " ", "<br>", projectRepoName, linker, true));
        if (mode == Render.NONE) {
            context.pushRenderMode(RenderMode.allow((long)4224L));
        } else if (mode == Render.LINKS_ONLY) {
            context.pushRenderMode(RenderMode.LINKS_ONLY.or(RenderMode.allow((long)1024L)));
        } else {
            context.pushRenderMode(RenderMode.ALL_WITH_NO_MACRO_ERRORS);
        }
        return super.highlight(text, queryText, context, returnNullIfNoHits);
    }

    private Linker getLinker(String projectRepoName, String projectKey) {
        try {
            return this.linkerService.getLinker(projectRepoName, projectKey);
        }
        catch (RepositoryNotFoundException e2) {
            Logs.APP_LOG.warn((Object)e2.getMessage());
            return this.linkerService.getDefaultLinker();
        }
    }

    static enum Render {
        NONE,
        LINKS_ONLY,
        ALL;

    }
}

