/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.reviews;

import com.atlassian.crucible.activity.lucene.DefaultReviewItemIndexer;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.reviews.CrucibleQuickSearcher;
import com.atlassian.fecru.search.reviews.ReviewPermaIdResult;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReviewPermaIdSearcher
extends CrucibleQuickSearcher<ReviewPermaIdResult> {
    @Autowired
    public ReviewPermaIdSearcher(ProjectManager projectManager) {
        super(SearchType.REVIEW_DETAILS, projectManager);
    }

    @Override
    protected Query generateQuery(String userQuery, SearchScope scope) {
        return this.getReviewItemIndexer().queryForReviewDetails(userQuery, scope);
    }

    @Override
    protected SearchResults<ReviewPermaIdResult> buildSearchResults(TopDocs hits, SearchScope scope, IndexSearcher searcher, String queryText) {
        ArrayList<ReviewPermaIdResult> resultsList = new ArrayList<ReviewPermaIdResult>();
        for (int i2 = 0; i2 < hits.scoreDocs.length; ++i2) {
            ScoreDoc scoreDoc = hits.scoreDocs[i2];
            try {
                if (!scope.inScope(i2)) continue;
                ReviewPermaIdResult result = DefaultReviewItemIndexer.loadReviewPermaIdDoc(searcher, scoreDoc.doc);
                resultsList.add(result);
                continue;
            }
            catch (IOException e2) {
                Logs.APP_LOG.info((Object)("Problem loading review permaId result: " + e2.getMessage()), (Throwable)e2);
            }
        }
        return new SearchResults<ReviewPermaIdResult>(hits.totalHits, resultsList, this.getType());
    }
}

