/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.reviews;

import com.atlassian.crucible.activity.lucene.DefaultReviewItemIndexer;
import com.atlassian.fecru.search.common.api.QuickSearcher;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.reviews.CrucibleQuickSearcher;
import com.atlassian.fecru.search.reviews.ReviewDetailsResult;
import com.atlassian.fecru.search.reviews.ReviewWikiHighlighter;
import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.LinkerService;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReviewDetailsSearcher
extends CrucibleQuickSearcher<ReviewDetailsResult>
implements QuickSearcher<ReviewDetailsResult> {
    private final ReviewWikiHighlighter highlighter;

    @Autowired
    public ReviewDetailsSearcher(WikiRenderer wikiRenderer, LinkerService linkerService, ProjectManager projectManager) {
        super(SearchType.REVIEW_DETAILS, projectManager);
        this.highlighter = new ReviewWikiHighlighter(wikiRenderer, linkerService);
    }

    @Override
    protected Query generateQuery(String userQuery, SearchScope scope) {
        return this.getReviewItemIndexer().queryForReviewDetails(userQuery, scope);
    }

    @Override
    protected SearchResults<ReviewDetailsResult> buildSearchResults(TopDocs hits, SearchScope scope, IndexSearcher searcher, String queryText) {
        ArrayList<ReviewDetailsResult> resultsList = new ArrayList<ReviewDetailsResult>();
        for (int i2 = 0; i2 < hits.scoreDocs.length; ++i2) {
            ScoreDoc scoreDoc = hits.scoreDocs[i2];
            try {
                if (!scope.inScope(i2)) continue;
                ReviewDetailsResult result = DefaultReviewItemIndexer.loadReviewDetailsDoc(this.getProjectManager(), searcher, scoreDoc.doc);
                if (scope.isHighlights()) {
                    this.generateHighlights(result, queryText);
                }
                resultsList.add(result);
                continue;
            }
            catch (IOException e2) {
                Logs.APP_LOG.info((Object)("Problem loading review details result: " + e2.getMessage()), (Throwable)e2);
            }
        }
        return new SearchResults<ReviewDetailsResult>(hits.totalHits, resultsList, this.getType());
    }

    private void generateHighlights(ReviewDetailsResult result, String queryText) {
        String projectKey = result.getHeader().getProjectKey();
        String projectRepo = result.getHeader().getProjectDefaultRepository();
        result.setTitleHighlight(this.highlighter.highlight(result.getTitle(), queryText, projectKey, projectRepo, ReviewWikiHighlighter.Render.NONE, false));
        result.setObjectivesHighlight(this.highlighter.highlight(result.getObjectives(), queryText, projectKey, projectRepo, ReviewWikiHighlighter.Render.ALL, true));
        result.setSummaryHighlight(this.highlighter.highlight(result.getSummary(), queryText, projectKey, projectRepo, ReviewWikiHighlighter.Render.ALL, true));
        result.setLinkedIssueHighlight(this.highlighter.highlight(result.getLinkedIssue(), queryText, projectKey, projectRepo, ReviewWikiHighlighter.Render.LINKS_ONLY, true));
        result.setLinkedReviewsHighlight(this.highlighter.highlight(result.getLinkedReviews(), queryText, projectKey, projectRepo, ReviewWikiHighlighter.Render.LINKS_ONLY, true));
    }

    @Override
    protected Sort getSort(SearchScope scope) {
        return scope.getSortOrder().getLuceneSort();
    }
}

