/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.reviews;

import com.atlassian.crucible.activity.lucene.DefaultReviewItemIndexer;
import com.atlassian.fecru.search.common.api.QuickSearcher;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.reviews.CrucibleQuickSearcher;
import com.atlassian.fecru.search.reviews.ReviewCommentResult;
import com.atlassian.fecru.search.reviews.ReviewWikiHighlighter;
import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.LinkerService;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReviewCommentsSearcher
extends CrucibleQuickSearcher<ReviewCommentResult>
implements QuickSearcher<ReviewCommentResult> {
    private final ReviewWikiHighlighter highlighter;

    @Autowired
    public ReviewCommentsSearcher(WikiRenderer wikiRenderer, LinkerService linkerService, ProjectManager projectManager) {
        super(SearchType.REVIEW_COMMENTS, projectManager);
        this.highlighter = new ReviewWikiHighlighter(wikiRenderer, linkerService);
    }

    @Override
    protected Query generateQuery(String userQuery, SearchScope scope) {
        return this.getReviewItemIndexer().queryForReviewComments(userQuery, scope);
    }

    @Override
    protected SearchResults<ReviewCommentResult> buildSearchResults(TopDocs hits, SearchScope scope, IndexSearcher searcher, String queryText) {
        ArrayList<ReviewCommentResult> resultsList = new ArrayList<ReviewCommentResult>(scope.length());
        for (int i2 = 0; i2 < hits.scoreDocs.length; ++i2) {
            ScoreDoc scoreDoc = hits.scoreDocs[i2];
            try {
                if (!scope.inScope(i2)) continue;
                ReviewCommentResult result = DefaultReviewItemIndexer.loadReviewCommentDoc(this.getProjectManager(), searcher, scoreDoc.doc);
                if (scope.isHighlights()) {
                    this.generateHighlights(result, queryText);
                }
                resultsList.add(result);
                continue;
            }
            catch (IOException e2) {
                Logs.APP_LOG.info((Object)("Problem loading review comments result: " + e2.getMessage()), (Throwable)e2);
            }
        }
        return new SearchResults<ReviewCommentResult>(hits.totalHits, resultsList, this.getType());
    }

    private void generateHighlights(ReviewCommentResult result, String queryText) {
        String projectKey = result.getHeader().getProjectKey();
        String projectRepo = result.getHeader().getProjectDefaultRepository();
        result.setCommentText(this.highlighter.highlight(result.getCommentText(), queryText, projectKey, projectRepo, ReviewWikiHighlighter.Render.ALL, false));
        result.setReviewTitle(TextUtils.htmlEncode((String)result.getReviewTitle()));
    }

    @Override
    protected Sort getSort(SearchScope scope) {
        return scope.getSortOrder().getLuceneSort();
    }
}

