/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.reviews;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.fecru.search.common.api.SearchResult;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.LuceneSearcher;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CrucibleQuickSearcher<T extends SearchResult>
extends LuceneSearcher {
    private final SearchType type;
    private ReviewItemIndexer reviewItemIndexer;
    private final ProjectManager projectManager;

    @Autowired
    public CrucibleQuickSearcher(SearchType type, ProjectManager projectManager) {
        this.type = type;
        this.projectManager = projectManager;
    }

    @Autowired
    public void setReviewItemIndexer(ReviewItemIndexer reviewItemIndexer) {
        this.reviewItemIndexer = reviewItemIndexer;
    }

    protected abstract SearchResults<T> buildSearchResults(TopDocs var1, SearchScope var2, IndexSearcher var3, String var4);

    protected abstract Query generateQuery(String var1, SearchScope var2);

    public SearchResults<T> search(final String query, final SearchScope scope) {
        try {
            final BooleanQuery mainQ = new BooleanQuery();
            Query searcherQuery = this.generateQuery(query, scope);
            mainQ.add(searcherQuery, BooleanClause.Occur.MUST);
            if (!Strings.isNullOrEmpty((String)scope.getProjectKey())) {
                Project project = this.projectManager.getProjectByKey(scope.getProjectKey());
                if (project != null) {
                    Query projectQ = this.getReviewItemIndexer().queryToRestrictByProject(project);
                    mainQ.add(projectQ, BooleanClause.Occur.MUST);
                } else {
                    Logs.APP_LOG.debug((Object)("No project for key " + scope.getProjectKey() + ". Not filtering on project."));
                }
            }
            return this.withIndexSearcher(new LuceneConnection.IndexSearcherAction<SearchResults<T>>(){

                @Override
                public SearchResults<T> perform(IndexSearcher indexSearcher) throws IOException, DbException {
                    TopDocs docs = CrucibleQuickSearcher.this.doSearch(indexSearcher, (Query)mainQ, scope.to(), CrucibleQuickSearcher.this.getSort(scope));
                    if (scope.isCountOnly()) {
                        return new SearchResults(docs.totalHits, CrucibleQuickSearcher.this.getType());
                    }
                    return CrucibleQuickSearcher.this.buildSearchResults(docs, scope, indexSearcher, query);
                }
            });
        }
        catch (DbException e2) {
            Logs.APP_LOG.info((Object)("Could not load review search results: " + e2.getMessage()), (Throwable)e2);
            return new SearchResults(0, Collections.emptyList(), this.getType());
        }
    }

    protected Sort getSort(SearchScope scope) {
        return null;
    }

    protected SearchResults<T> withIndexSearcher(LuceneConnection.IndexSearcherAction<SearchResults<T>> action) {
        return this.getReviewItemIndexer().withIndexSearcher(action);
    }

    public SearchType getType() {
        return this.type;
    }

    ReviewItemIndexer getReviewItemIndexer() {
        return this.reviewItemIndexer;
    }

    ProjectManager getProjectManager() {
        return this.projectManager;
    }
}

