/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.quicknav;

import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.search.common.api.QuickSearcher;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.quicknav.UserSearchResult;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserSearchCriteria;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserSearcher
implements QuickSearcher<UserSearchResult> {
    private final UserManager userManager;
    private final RootConfig rootConfig;
    private final EffectiveUserProvider effectiveUserProvider;

    @Autowired
    public UserSearcher(UserManager userManager, RootConfig rootConfig, EffectiveUserProvider effectiveUserProvider) {
        this.userManager = userManager;
        this.rootConfig = rootConfig;
        this.effectiveUserProvider = effectiveUserProvider;
    }

    @Override
    public SearchResults<UserSearchResult> search(String query, SearchScope scope) {
        return this.search(query, scope, LicenseManager.getLicensedGlobalPermissionType());
    }

    public SearchResults<UserSearchResult> search(String query, SearchScope scope, GlobalPermissionType permission) {
        if (!this.rootConfig.isAnonAccessAllowed() && !this.rootConfig.isCruAnonAccessAllowed() && this.effectiveUserProvider.isAnonymous()) {
            return new SearchResults<UserSearchResult>(0, SearchType.USERS);
        }
        Page<FecruUser> matchingUsers = this.userManager.searchUsers(UserSearchCriteria.create().named(query).withPermissions(permission), PageRequest.create((Integer)scope.from(), (Integer)scope.to()));
        List result = StreamSupport.stream(matchingUsers.getValues().spliterator(), false).map(user -> new UserSearchResult(user.getId(), user.getUsername(), user.getDisplayName(), user.getEmail())).collect(Collectors.toList());
        return new SearchResults<UserSearchResult>(matchingUsers.getSize(), result, this.getType());
    }

    @Override
    public SearchType getType() {
        return SearchType.USERS;
    }
}

