/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.quicknav;

import com.atlassian.fecru.search.common.api.SearchResult;
import com.atlassian.fecru.search.common.api.SearchType;
import java.util.Comparator;

public class UserSearchResult
implements SearchResult {
    private final Integer id;
    private final String username;
    private final String displayName;
    private final String email;
    public static final Comparator<UserSearchResult> DISPLAY_NAME_COMPARATOR = new Comparator<UserSearchResult>(){

        @Override
        public int compare(UserSearchResult o1, UserSearchResult o2) {
            return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        }
    };

    public UserSearchResult(Integer id, String username, String displayName, String email) {
        this.id = id;
        this.username = username;
        this.displayName = displayName;
        this.email = email;
    }

    public Integer getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public SearchType getType() {
        return SearchType.USERS;
    }
}

