/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.quicknav;

import com.atlassian.fecru.search.common.api.QuickSearcher;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.quicknav.RepositorySearchResult;
import com.atlassian.fisheye.StoppableVisitor;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositorySearcher
implements QuickSearcher<RepositorySearchResult> {
    @Autowired
    private RepositoryManager repositoryManager;

    @Override
    public SearchResults<RepositorySearchResult> search(String query, final SearchScope scope) {
        final Pattern pattern = Pattern.compile("\\b" + Pattern.quote(query), 2);
        final ArrayList matches = Lists.newArrayListWithExpectedSize((int)scope.length());
        final AtomicInteger resultNumber = new AtomicInteger(0);
        this.repositoryManager.visitAccessibleRepositories(new StoppableVisitor<RepositoryHandle>(){

            @Override
            public boolean visit(RepositoryHandle rep) {
                if (rep.isRunning() && pattern.matcher(rep.getName()).find() && scope.inScope(resultNumber.getAndIncrement())) {
                    matches.add(new RepositorySearchResult(rep.getName()));
                    if (matches.size() >= scope.length()) {
                        return false;
                    }
                }
                return true;
            }
        });
        return new SearchResults<RepositorySearchResult>(resultNumber.get(), matches, this.getType());
    }

    @Override
    public SearchType getType() {
        return SearchType.REPOSITORIES;
    }
}

