/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.quicknav;

import com.atlassian.fecru.search.common.api.QuickSearcher;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.quicknav.ProjectSearchResult;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectSearcher
implements QuickSearcher<ProjectSearchResult> {
    @Autowired
    private SecureProjectManager projectManager;
    @Autowired
    private EffectiveUserProvider effectiveUserProvider;

    @Override
    public SearchResults<ProjectSearchResult> search(String query, SearchScope scope) {
        return this.search(query, UserActionManager.Action.ACTION_VIEW, scope);
    }

    public SearchResults<ProjectSearchResult> search(String query, UserActionManager.Action action, SearchScope scope) {
        final Pattern pattern = Pattern.compile("\\b" + Pattern.quote(query) + ".*", 2);
        Iterable projects = Iterables.filter(this.projectManager.getProjectsCanDoActionIn(this.effectiveUserProvider.getEffectivePrincipal(), action), (Predicate)new Predicate<Project>(){

            public boolean apply(Project project) {
                return pattern.matcher(project.getName()).find() || pattern.matcher(project.getProjKey()).find();
            }
        });
        int totalCount = Iterables.size((Iterable)projects);
        if (scope.isCountOnly()) {
            return new SearchResults<ProjectSearchResult>(totalCount, this.getType());
        }
        ArrayList results = Lists.newArrayList((Iterable)projects);
        Collections.sort(results, new Project.NameComparator());
        if (scope.from() > results.size()) {
            return new SearchResults<ProjectSearchResult>(0, this.getType());
        }
        int from = Math.min(scope.from(), results.size());
        int to = Math.min(scope.to(), results.size());
        List trimmed = Lists.transform(results.subList(from, to), (Function)new Function<Project, ProjectSearchResult>(){

            public ProjectSearchResult apply(Project input) {
                return new ProjectSearchResult(input.getProjKey(), input.getName());
            }
        });
        return new SearchResults<ProjectSearchResult>(totalCount, trimmed, this.getType());
    }

    @Override
    public SearchType getType() {
        return SearchType.PROJECTS;
    }
}

