/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.index.service;

import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.model.FieldInfo;
import com.atlassian.fecru.search.index.service.DocConverter;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class DocInfoManager<D extends DocInfo> {
    private static LoadingCache<Class<? extends DocInfo>, Iterable<Field>> ANNOTATION_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class<? extends DocInfo>, Iterable<Field>>(){
        private final Predicate<Field> HAS_FIELD_INFO_ANNOTATION = new Predicate<Field>(){

            public boolean apply(Field field) {
                return field.isAnnotationPresent(FieldInfo.class);
            }
        };

        public Iterable<Field> load(@Nonnull Class<? extends DocInfo> clazz) {
            ImmutableList.Builder result = ImmutableList.builder().addAll(Iterables.filter(Arrays.asList(clazz.getDeclaredFields()), this.HAS_FIELD_INFO_ANNOTATION));
            for (Class<? extends DocInfo> superclass = clazz.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
                result.addAll(Iterables.filter(Arrays.asList(superclass.getDeclaredFields()), this.HAS_FIELD_INFO_ANNOTATION));
            }
            ImmutableList allFields = result.build();
            for (Field field : allFields) {
                field.setAccessible(true);
            }
            return allFields;
        }
    });
    protected final IndexWriter writer;
    @Nullable
    protected IndexReader reader;
    @Nullable
    protected IndexSearcher searcher;

    public DocInfoManager(IndexWriter writer, @Nullable IndexReader reader) {
        this.writer = writer;
        this.reader = reader;
    }

    private IndexSearcher getSearcher() {
        if (this.searcher == null && this.reader != null) {
            this.searcher = new IndexSearcher(this.reader);
        }
        return this.searcher;
    }

    public void updateDoc(D infoDoc) throws IOException {
        Document doc = this.convertToDocument((DocInfo)infoDoc);
        this.writer.updateDocument(infoDoc.getKeyTerm(), doc, infoDoc.getAnalyzer());
    }

    public void addDoc(D infoDoc) throws IOException {
        Document doc = this.convertToDocument((DocInfo)infoDoc);
        this.writer.addDocument(doc, infoDoc.getAnalyzer());
    }

    public <T> List<T> findDocs(Query query, final DocConverter<T> converter, int limit) throws IOException {
        TopDocs topDocs = this.getSearcher().search(query, limit);
        return Lists.transform(Arrays.asList(topDocs.scoreDocs), (Function)new Function<ScoreDoc, T>(){

            public T apply(ScoreDoc docId) {
                try {
                    return converter.convert(DocInfoManager.this.searcher, docId);
                }
                catch (IOException e2) {
                    throw Throwables.propagate((Throwable)e2);
                }
            }
        });
    }

    public <T> T findDoc(Query query, DocConverter<T> converter) throws IOException {
        IndexSearcher searcher = this.getSearcher();
        TopDocs topDocs = searcher.search(query, 1);
        if (topDocs.scoreDocs.length > 0) {
            return converter.convert(searcher, topDocs.scoreDocs[0]);
        }
        return null;
    }

    public int countDocs(Query query) throws IOException {
        return LuceneHelper.countMatchingDocuments(this.getSearcher(), query);
    }

    private Document convertToDocument(DocInfo infoDoc) {
        Document doc = new Document();
        List<Fieldable> fields = this.extractFields(infoDoc);
        for (Fieldable field : fields) {
            doc.add(field);
        }
        Fieldable key = doc.getFieldable(infoDoc.getKeyTerm().field());
        if (key == null) {
            throw new IllegalStateException("No key field for doc " + infoDoc);
        }
        if (key.isTokenized()) {
            throw new IllegalStateException("Document key should not be tokenized " + infoDoc);
        }
        return doc;
    }

    private List<Fieldable> extractFields(DocInfo infoDoc) {
        ImmutableList.Builder fieldables = ImmutableList.builder();
        for (Field field : (Iterable)ANNOTATION_CACHE.getUnchecked(infoDoc.getClass())) {
            try {
                Class<?> type = field.getType();
                if (Fieldable.class.isAssignableFrom(type)) {
                    Fieldable fieldable = (Fieldable)field.get(infoDoc);
                    if (fieldable == null) continue;
                    fieldables.add((Object)fieldable);
                    continue;
                }
                if (Iterable.class.isAssignableFrom(type)) {
                    Iterable list = (Iterable)field.get(infoDoc);
                    for (Object o2 : list) {
                        Fieldable fieldable = (Fieldable)o2;
                        if (fieldable == null) continue;
                        fieldables.add((Object)fieldable);
                    }
                    continue;
                }
                throw new IllegalStateException("Field " + field + " annotated with @FieldInfo type unknown.");
            }
            catch (IllegalAccessException e2) {
                throw new IllegalStateException(e2);
            }
        }
        return fieldables.build();
    }

    public void closeReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.searcher != null) {
            this.searcher.close();
            this.searcher = null;
        }
    }
}

