/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.index.model;

import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.model.FieldInfo;
import com.cenqua.fisheye.Path;
import java.util.Date;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public abstract class RevisionDocInfo
implements DocInfo {
    protected static final String FLD_PATH = "path_0";
    protected static final String FLD_FILENAME = "filename_0";
    protected static final String FLD_CSID = "csid_0";
    public static final String FLD_REVID = "revid";
    protected static final String FLD_TIMESTAMP = "timestamp";
    protected static final String FLD_LASTMODIFIED = "lastModified";
    protected static final String FLD_CVSFILEREVISION = "cvsfilerevision";
    @FieldInfo
    private final Field key;
    @FieldInfo
    private final Field dirPath;
    @FieldInfo
    private final Field filename;
    @FieldInfo
    private final Field csid;
    @FieldInfo
    private final NumericField revid;
    @FieldInfo
    private final NumericField timestamp;
    @FieldInfo
    private final NumericField lastModified;
    @FieldInfo
    private final Field cvsfilerevision;
    @FieldInfo
    private final Field doctype;

    public RevisionDocInfo(Path path, String csid, int revid, long timestamp, int lastModified, String cvsfilerevision) {
        this.dirPath = new Field(FLD_PATH, "/" + path.trimLast().toString(), Field.Store.YES, Field.Index.ANALYZED);
        this.filename = new Field(FLD_FILENAME, path.getName(), Field.Store.YES, Field.Index.ANALYZED);
        this.revid = new NumericField(FLD_REVID, Field.Store.YES, true).setIntValue(revid);
        this.doctype = new Field("doctype", this.getDoctype(), Field.Store.NO, Field.Index.ANALYZED_NO_NORMS);
        this.timestamp = timestamp >= 0L ? new NumericField(FLD_TIMESTAMP, Field.Store.YES, false).setLongValue(timestamp) : null;
        this.lastModified = lastModified >= 0 ? new NumericField(FLD_LASTMODIFIED, Field.Store.NO, true).setIntValue(lastModified) : null;
        this.csid = csid != null ? new Field(FLD_CSID, csid, Field.Store.YES, Field.Index.NOT_ANALYZED) : null;
        this.cvsfilerevision = cvsfilerevision != null ? new Field(FLD_CVSFILEREVISION, cvsfilerevision, Field.Store.YES, Field.Index.NOT_ANALYZED) : null;
        String keyValue = this.getDoctype() + "_" + this.getDirPath() + "/" + this.getFilename() + "@" + this.getRevId();
        this.key = new Field("key", keyValue, Field.Store.NO, Field.Index.NOT_ANALYZED);
    }

    protected abstract String getDoctype();

    @Override
    public Term getKeyTerm() {
        return new Term("key", this.key.stringValue());
    }

    public String getDirPath() {
        return this.dirPath.stringValue();
    }

    public String getFilename() {
        return this.filename.stringValue();
    }

    public String getCvsFileRevision() {
        return this.cvsfilerevision != null ? this.cvsfilerevision.stringValue() : null;
    }

    public String getCsid() {
        return this.csid != null ? this.csid.stringValue() : null;
    }

    public String getRevId() {
        return this.revid.stringValue();
    }

    public Date getTimestamp() {
        return this.timestamp != null ? new Date(this.timestamp.getNumericValue().longValue()) : null;
    }

    public static Sort getDateSort() {
        return new Sort(new SortField(FLD_LASTMODIFIED, 4, true));
    }
}

