/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.index.model;

import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.search.common.lucene.RecencyBoostingQuery;
import com.atlassian.fecru.search.index.model.FieldInfo;
import com.atlassian.fecru.search.index.model.RevisionDocInfo;
import com.atlassian.fecru.search.index.service.DocConverter;
import com.atlassian.fisheye.bucket.TimeZoneVariables;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.cenqua.fisheye.lucene.PathAnalyzer;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;

public class DiffDocInfo
extends RevisionDocInfo {
    public static final String FLD_ADDED = "addedText";
    public static final String FLD_REMOVED = "removedText";
    public static final String DOCTYPE = "difftext";
    @FieldInfo
    private final Fieldable addedText;
    @FieldInfo
    private final Fieldable removedText;
    private static final Map<String, Analyzer> ANALYZER_MAP = ImmutableMap.of((Object)"path_0", (Object)((Object)new PathAnalyzer()), (Object)"addedText", (Object)((Object)new FreeTextAnalyzer()), (Object)"removedText", (Object)((Object)new FreeTextAnalyzer()));
    public static final DocConverter<DiffDocInfo> CONVERTER = new DocConverter<DiffDocInfo>(){
        private final FieldSelector SELECTOR = LuceneUtils.multipleFieldsSelector("csid_0", "revid", "filename_0", "path_0", "cvsfilerevision");

        @Override
        public DiffDocInfo convert(IndexSearcher searcher, ScoreDoc hit) throws IOException {
            Document doc = searcher.doc(hit.doc, this.SELECTOR);
            Path path = new Path(doc.get("path_0") + "/" + doc.get("filename_0"));
            String timestampStr = doc.get("timestamp");
            return new DiffDocInfo(null, null, path, doc.get("csid_0"), Integer.parseInt(doc.get("revid")), timestampStr != null ? Long.parseLong(timestampStr) : -1L, doc.get("cvsfilerevision"));
        }
    };

    public DiffDocInfo(Reader added, Reader removed, Path path, String csid, int revid, long timestamp, String cvsfilerevision) {
        super(path, csid, revid, timestamp, TimeZoneVariables.reduceMillisToHours(timestamp), cvsfilerevision);
        this.addedText = added != null ? new Field(FLD_ADDED, added, Field.TermVector.WITH_OFFSETS) : null;
        this.removedText = removed != null ? new Field(FLD_REMOVED, removed, Field.TermVector.WITH_OFFSETS) : null;
    }

    @Override
    protected String getDoctype() {
        return DOCTYPE;
    }

    @Override
    public Analyzer getAnalyzer() {
        return LuceneUtils.createPerFieldAnalyzer((Analyzer)new KeywordAnalyzer(), ANALYZER_MAP);
    }

    private static Analyzer analyzerFor(String field) {
        return ANALYZER_MAP.get(field);
    }

    public static Query queryByAddedOrRemoved(String userQuery, SearchScope scope) {
        BooleanQuery mergedQuery = new BooleanQuery();
        if (!Strings.isNullOrEmpty((String)userQuery)) {
            PhraseQuery added = LuceneUtils.generatePhraseQuery(userQuery, FLD_ADDED, ANALYZER_MAP.get(FLD_ADDED));
            PhraseQuery removed = LuceneUtils.generatePhraseQuery(userQuery, FLD_REMOVED, ANALYZER_MAP.get(FLD_REMOVED));
            added.setBoost(2.0f);
            BooleanQuery inputQuery = new BooleanQuery();
            inputQuery.add((Query)added, BooleanClause.Occur.SHOULD);
            inputQuery.add((Query)removed, BooleanClause.Occur.SHOULD);
            mergedQuery.add((Query)inputQuery, BooleanClause.Occur.MUST);
        }
        if (scope.getTimeBucket() != QuickSearchTimeBucket.ANY_DATE) {
            mergedQuery.add((Query)NumericRangeQuery.newIntRange((String)"lastModified", (Integer)TimeZoneVariables.reduceMillisToHours(scope.getTimeBucket().getStartTime().getMillis()), null, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        }
        return new RecencyBoostingQuery((Query)(mergedQuery.clauses().isEmpty() ? new MatchAllDocsQuery() : mergedQuery), 2.0f, "lastModified");
    }

    public static Query queryByAdded(String match) {
        return DiffDocInfo.smartPhraseQueryByField(FLD_ADDED, match);
    }

    public static Query queryByRemoved(String match) {
        return DiffDocInfo.smartPhraseQueryByField(FLD_REMOVED, match);
    }

    private static Query smartPhraseQueryByField(String fieldname, String match) {
        return LuceneUtils.parsePhrase(match, fieldname, DiffDocInfo.analyzerFor(fieldname));
    }
}

