/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.index.model;

import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.search.common.lucene.RecencyBoostingQuery;
import com.atlassian.fecru.search.index.model.FieldInfo;
import com.atlassian.fecru.search.index.model.RevisionDocInfo;
import com.atlassian.fecru.search.index.service.DocConverter;
import com.atlassian.fisheye.bucket.TimeZoneVariables;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.cenqua.fisheye.lucene.PathAnalyzer;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;

public class ContentDocInfo
extends RevisionDocInfo {
    public static final String FLD_CONTENT = "contents";
    @FieldInfo
    private final Fieldable content;
    private static final String DOCTYPE = "contents";
    private static final Map<String, Analyzer> ANALYZER_MAP = ImmutableMap.of((Object)"path_0", (Object)((Object)new PathAnalyzer()), (Object)"contents", (Object)((Object)new FreeTextAnalyzer()));
    public static final DocConverter<ContentDocInfo> CONVERTER = new DocConverter<ContentDocInfo>(){
        private final FieldSelector SELECTOR = LuceneUtils.multipleFieldsSelector("path_0", "filename_0", "csid_0", "timestamp", "cvsfilerevision");

        @Override
        public ContentDocInfo convert(IndexSearcher searcher, ScoreDoc hit) throws IOException {
            Document doc = searcher.doc(hit.doc, this.SELECTOR);
            Path path = new Path(doc.get("path_0") + "/" + doc.get("filename_0"));
            String timestamp = doc.get("timestamp");
            return new ContentDocInfo(null, path, doc.get("csid_0"), -1, timestamp != null ? Long.parseLong(timestamp) : -1L, doc.get("cvsfilerevision"));
        }
    };

    public ContentDocInfo(Reader content, Path path, String csid, int revid, long timestamp, String cvsfilerevision) {
        super(path, csid, revid, timestamp, TimeZoneVariables.reduceMillisToHours(timestamp), cvsfilerevision);
        this.content = content != null ? new Field("contents", content, Field.TermVector.WITH_OFFSETS) : null;
    }

    @Override
    protected String getDoctype() {
        return "contents";
    }

    @Override
    public Analyzer getAnalyzer() {
        return LuceneUtils.createPerFieldAnalyzer((Analyzer)new KeywordAnalyzer(), ANALYZER_MAP);
    }

    public static Query queryByContent(String query, SearchScope scope) {
        QuickSearchTimeBucket timeBucket;
        BooleanQuery mergedQuery = new BooleanQuery();
        if (!Strings.isNullOrEmpty((String)query)) {
            PhraseQuery phraseQuery = LuceneUtils.generatePhraseQuery(query, "contents", ANALYZER_MAP.get("contents"));
            mergedQuery.add((Query)phraseQuery, BooleanClause.Occur.MUST);
        }
        if ((timeBucket = scope.getTimeBucket()) != QuickSearchTimeBucket.ANY_DATE) {
            mergedQuery.add((Query)NumericRangeQuery.newIntRange((String)"lastModified", (Integer)TimeZoneVariables.reduceMillisToHours(timeBucket.getStartTime().getMillis()), null, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        }
        return new RecencyBoostingQuery((Query)(mergedQuery.clauses().isEmpty() ? new MatchAllDocsQuery() : mergedQuery), 2.0f, "lastModified");
    }

    public static Query queryByPath(Path path) {
        BooleanQuery query = new BooleanQuery(true);
        Path dirpath = path.trimLast();
        for (int i2 = dirpath.getNumComponents() - 1; i2 >= 0; --i2) {
            query.add((Query)new TermQuery(new Term("path_0", dirpath.getComponent(i2))), BooleanClause.Occur.MUST);
        }
        query.add((Query)new TermQuery(new Term("filename_0", path.getName())), BooleanClause.Occur.MUST);
        return query;
    }

    private static Analyzer analyzerFor(String fieldName) {
        return ANALYZER_MAP.get(fieldName);
    }

    public static Query queryByContentRaw(String match) {
        return LuceneUtils.parsePhrase(match, "contents", ContentDocInfo.analyzerFor("contents"));
    }
}

