/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.filepaths;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FilePathUtils {
    private static final Pattern UPPERCASES = Pattern.compile("[A-Z]");
    private static final Pattern CAMELCASES = Pattern.compile("[A-Z0-9][a-z]*[A-Z0-9]");

    public static boolean isAntGlob(String s2) {
        return s2.indexOf(47) >= 0;
    }

    public static String formatAntGlob(String s2) {
        if (s2.charAt(0) != '/') {
            s2 = '/' + s2;
        }
        return s2;
    }

    public static boolean isCamelCase(String s2) {
        return UPPERCASES.matcher(s2).find();
    }

    public static String breakCamelCases(String s2) {
        Matcher matcher;
        StringBuilder sb = new StringBuilder(s2);
        while ((matcher = CAMELCASES.matcher(sb)).find()) {
            sb.insert(matcher.end() - 1, ' ');
        }
        return sb.toString();
    }

    public static String removeNonAlphaNumeric(String s2, boolean keepWildcards, boolean keepSpaces) {
        StringBuilder sb = new StringBuilder(s2);
        for (int i2 = 0; i2 < sb.length(); ++i2) {
            char c2 = sb.charAt(i2);
            if (c2 == '.' || Character.isLetterOrDigit(c2) || keepWildcards && (c2 == '*' || c2 == '?') || keepSpaces && Character.isSpaceChar(c2)) continue;
            sb.deleteCharAt(i2--);
        }
        return sb.toString();
    }
}

