/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.filepaths;

import com.atlassian.fecru.search.common.SearchUtils;
import com.atlassian.fecru.search.common.api.QuickSearcher;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.CrossRepoSearcher;
import com.atlassian.fecru.search.common.lucene.CrossRepoSearcherState;
import com.atlassian.fecru.search.filepaths.FilePathHighlighter;
import com.atlassian.fecru.search.filepaths.FilePathResult;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.atlassian.fugue.Option;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.crossrepo.AbstractRepositoryQueryBuilder;
import com.cenqua.fisheye.crossrepo.PathDocInfo;
import com.cenqua.fisheye.crossrepo.PathQueryBuilder;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.searcher.PayloadIndexSearcher;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilePathSearcher
extends CrossRepoSearcher<FilePathResult>
implements QuickSearcher<FilePathResult> {
    private static final int MAX_NUM_REVISIONS = 3;

    @Autowired
    public FilePathSearcher(RepositoryManager repositoryManager, CrossRepLuceneIndex crossRepLuceneIndex) {
        super(SearchType.FILE_PATHS, CrossRepLuceneIndexes.METADATA, repositoryManager, crossRepLuceneIndex);
    }

    @Override
    protected Query generateQuery(String userText, PayloadIndexSearcher<CrossRepoSearcherState> searcher, SearchScope scope, CrossRepoSearcherState state) {
        try {
            return ((AbstractRepositoryQueryBuilder)((PathQueryBuilder)((PathQueryBuilder)PathQueryBuilder.newPathCrossRepoQueryBuilder().optimalRepositoryQuery(state.getIncludeRepos(), state.getExcludeRepos())).lastModifiedIn(scope.getTimeBucket())).queryByPath(userText)).build();
        }
        catch (IOException e2) {
            Logs.APP_LOG.info((Object)("Could not create query for " + userText + " " + e2.getMessage()), (Throwable)e2);
            return null;
        }
    }

    @Override
    protected SearchResults<FilePathResult> buildSearchResults(TopDocs topDocs, SearchScope scope, PayloadIndexSearcher<CrossRepoSearcherState> searcher, String queryText, Query query) {
        ArrayList<FilePathResult> results = new ArrayList<FilePathResult>(scope.length());
        FilePathHighlighter highlighter = new FilePathHighlighter(queryText);
        for (int i2 = 0; i2 < topDocs.scoreDocs.length; ++i2) {
            ScoreDoc hit = topDocs.scoreDocs[i2];
            try {
                String highlightedPath;
                PathDocInfo info;
                if (!scope.inScope(i2) || (info = PathDocInfo.fromSearchHit(searcher, hit)) == null) continue;
                String fullPathString = info.getPath();
                String repName = info.getRepository();
                String string = highlightedPath = scope.isHighlights() ? highlighter.highlight(fullPathString) : null;
                if (!scope.isDetails()) {
                    results.add(new FilePathResult(repName, fullPathString, highlightedPath, Collections.emptyList(), 0, null, null, info.isDir()));
                    continue;
                }
                try {
                    Option<RepositoryEngine> repository = FilePathSearcher.getSearcherState(searcher).getEngine(repName);
                    if (repository.isDefined()) {
                        RepositoryEngine engine = (RepositoryEngine)repository.get();
                        RevisionCache<? extends ChangeSet> revisionCache = engine.getRevisionCache();
                        Path fullPath = new Path(fullPathString);
                        String defaultBranchName = revisionCache.getDefaultBranch();
                        FileRevision fileRevisionOnDefault = defaultBranchName != null ? revisionCache.getHeadRevisionOnBranchAtPath(defaultBranchName, fullPath) : null;
                        ArrayList<FileRevision> headRevisions = new ArrayList<FileRevision>(3);
                        int totalHeadRevisions = SearchUtils.loadLatestRevisions(engine, fullPath, headRevisions, 3);
                        boolean isDirectory = headRevisions.isEmpty() ? revisionCache.isDir(fullPath) : ((FileRevision)headRevisions.get(0)).isDir();
                        FilePathResult result = new FilePathResult(engine.getName(), fullPathString, highlightedPath, headRevisions, totalHeadRevisions, fileRevisionOnDefault, defaultBranchName, isDirectory);
                        results.add(result);
                        continue;
                    }
                    Logs.APP_LOG.debug((Object)("Omitting result: " + fullPathString + ", as it came from an unacquirable repo " + repName));
                }
                catch (DbException e2) {
                    Logs.APP_LOG.error((Object)("Can't fetch branches or directory status for " + fullPathString), (Throwable)e2);
                }
                continue;
            }
            catch (IOException e3) {
                Logs.APP_LOG.error((Object)("Could not fetch result from index: doc ID " + hit.doc), (Throwable)e3);
            }
        }
        return new SearchResults<FilePathResult>(topDocs.totalHits, results, this.getType());
    }

    @Override
    protected Sort getSort(SearchScope scope) {
        if (scope.getSortOrder() == SearchSortOrder.TOWARDS_PAST) {
            return new Sort(new SortField[]{new SortField("lastModifiedHrs", 4, true)});
        }
        return null;
    }
}

