/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.filepaths;

import com.atlassian.fecru.search.common.api.SearchResult;
import com.atlassian.fecru.search.common.api.SearchType;
import com.cenqua.fisheye.rep.FileRevision;
import java.util.List;
import javax.annotation.Nullable;

public final class FilePathResult
implements SearchResult {
    private final String repository;
    private final String logicalPath;
    private final String highlightedPath;
    private final boolean isDir;
    private final List<FileRevision> headRevisions;
    @Nullable
    private final FileRevision fileRevisionOnDefault;
    @Nullable
    private final String defaultBranchName;
    private final int numHeadRevisions;

    public FilePathResult(String repository, String logicalPath, String highlightedPath, List<FileRevision> headRevisions, int numHeadRevisions, @Nullable FileRevision fileRevisionOnDefault, @Nullable String defaultBranchName, boolean isDir) {
        this.repository = repository;
        this.logicalPath = logicalPath;
        this.highlightedPath = highlightedPath;
        this.headRevisions = headRevisions;
        this.numHeadRevisions = numHeadRevisions;
        this.isDir = isDir;
        this.fileRevisionOnDefault = fileRevisionOnDefault;
        this.defaultBranchName = defaultBranchName;
    }

    public String getRepository() {
        return this.repository;
    }

    public boolean isDir() {
        return this.isDir;
    }

    public boolean isHasRevisions() {
        return !this.headRevisions.isEmpty();
    }

    public List<FileRevision> getHeadRevisions() {
        return this.headRevisions;
    }

    public FileRevision getTopRevision() {
        if (this.fileRevisionOnDefault != null) {
            return this.fileRevisionOnDefault;
        }
        return this.isHasRevisions() ? this.headRevisions.get(0) : null;
    }

    @Nullable
    public FileRevision getFileRevisionOnDefault() {
        return this.fileRevisionOnDefault;
    }

    @Nullable
    public String getDefaultBranchName() {
        return this.defaultBranchName;
    }

    public int getBranchesCount() {
        return this.numHeadRevisions;
    }

    public String getLogicalPath() {
        return this.logicalPath;
    }

    @Nullable
    public String getHighlightedPath() {
        return this.highlightedPath;
    }

    @Override
    public SearchType getType() {
        return SearchType.FILE_PATHS;
    }
}

