/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.filepaths;

import com.atlassian.fecru.search.common.highlighting.SimpleHighlighter;
import com.atlassian.fecru.search.filepaths.FilePathUtils;
import org.apache.commons.io.FilenameUtils;

final class FilePathHighlighter
extends SimpleHighlighter {
    private final boolean isAntGlob;

    FilePathHighlighter(String queryText) {
        this(queryText, FilePathUtils.isCamelCase(queryText), FilePathUtils.isAntGlob(queryText));
    }

    FilePathHighlighter(String queryText, boolean isCamelCase, boolean isAntGlob) {
        super(FilePathHighlighter.format(queryText, isAntGlob, isCamelCase));
        this.isAntGlob = isAntGlob;
    }

    @Override
    public String highlight(String text) {
        if (this.isAntGlob) {
            return super.highlight(text);
        }
        String filename = FilenameUtils.getName((String)text);
        String directory = text.substring(0, text.length() - filename.length());
        return directory + super.highlight(filename);
    }

    private static String format(String s2, boolean isAntGlob, boolean isCamelCase) {
        if (isAntGlob) {
            return s2;
        }
        if (isCamelCase) {
            return FilePathUtils.breakCamelCases(s2);
        }
        return s2;
    }
}

