/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.diffs;

import com.atlassian.fecru.search.common.SearchUtils;
import com.atlassian.fecru.search.common.api.QuickSearcher;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.MultiIndexRepositorySearcher;
import com.atlassian.fecru.search.diffs.DiffFieldHighlighter;
import com.atlassian.fecru.search.diffs.DiffResult;
import com.atlassian.fecru.search.index.model.DiffDocInfo;
import com.atlassian.fecru.search.index.model.RevisionDocInfo;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.cvsrep.CvsRepositoryEngine;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.springframework.stereotype.Component;

@Component
public class DiffSearcher
extends MultiIndexRepositorySearcher<DiffResult>
implements QuickSearcher<DiffResult> {
    public DiffSearcher() {
        super(SearchType.CHANGESET_DIFFS, LuceneIndexes.DIFFTEXT);
    }

    @Override
    protected Query generateQuery(String userQuery, IndexSearcher searcher, SearchScope scope) {
        return DiffDocInfo.queryByAddedOrRemoved(userQuery, scope);
    }

    @Override
    protected SearchResults<DiffResult> buildSearchResults(TopDocs topDocs, SearchScope scope, IndexSearcher searcher, String queryText, Query query) {
        List<DiffResult> results = this.getFileDiffMatches(topDocs, searcher, query, scope);
        this.fetchChangesetInformation(results);
        this.generateHighlights(results);
        return new SearchResults<DiffResult>(topDocs.totalHits, results, this.getType());
    }

    private List<DiffResult> getFileDiffMatches(TopDocs topDocs, IndexSearcher multiSearcher, Query query, SearchScope scope) {
        ArrayList<DiffResult> results = new ArrayList<DiffResult>(scope.length());
        for (int i2 = 0; i2 < topDocs.scoreDocs.length; ++i2) {
            ScoreDoc hit = topDocs.scoreDocs[i2];
            try {
                if (!scope.inScope(i2)) continue;
                DiffDocInfo info = DiffDocInfo.CONVERTER.convert(multiSearcher, hit);
                RepositoryEngine repositoryEngine = this.getRepositoryForDocument(hit.doc, multiSearcher);
                String csid = repositoryEngine instanceof CvsRepositoryEngine ? this.findCvsCSID(repositoryEngine, info.getRevId()) : info.getCsid();
                String revid = repositoryEngine instanceof CvsRepositoryEngine ? info.getCvsFileRevision() : csid;
                String filename = info.getFilename();
                String directory = info.getDirPath();
                DiffFieldHighlighter highlighter = new DiffFieldHighlighter(multiSearcher, hit.doc, query);
                DiffResult result = new DiffResult(repositoryEngine, csid, SearchUtils.getDisplayId(repositoryEngine.getCfg().getRepositoryType(), csid));
                result.addFile(filename, directory, revid, highlighter);
                results.add(result);
                continue;
            }
            catch (IOException e2) {
                Logs.APP_LOG.info((Object)("Could not fetch result from index: doc ID " + hit.doc), (Throwable)e2);
            }
        }
        return results;
    }

    private void fetchChangesetInformation(List<DiffResult> results) {
        for (final DiffResult result : results) {
            final RepositoryEngine repository = result.getEngine();
            try {
                repository.getCrossRepLuceneConnection().withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<Void>(){

                    @Override
                    public Void perform(IndexSearcher indexSearcher) throws IOException, DbException {
                        if (result.getCsid() == null) {
                            return null;
                        }
                        TopDocs csHits = indexSearcher.search(((ChangesetQueryBuilder)ChangesetQueryBuilder.newBuilder(repository.getName()).changesetId(result.getCsid())).build(), 1);
                        if (csHits.totalHits > 0) {
                            try {
                                ChangesetDocInfo docInfo = ChangesetDocInfo.fromSearchHit(indexSearcher, csHits.scoreDocs[0]);
                                result.setAuthor(docInfo.getAuthor());
                                result.setComment(docInfo.getCommitMessage());
                                result.setDate(docInfo.getTimestamp());
                            }
                            catch (IOException e2) {
                                Logs.APP_LOG.info((Object)("Could not fetch csid " + result.getCsid() + "from index "), (Throwable)e2);
                            }
                        } else {
                            Logs.APP_LOG.debug((Object)("Search: no changeset found for csid " + result.getCsid()));
                        }
                        return null;
                    }
                });
            }
            catch (DbException e2) {
                Logs.APP_LOG.info((Object)("Could not open metadata index for repository " + repository.getName()), (Throwable)e2);
            }
        }
    }

    @Override
    protected Sort getSort(SearchScope scope) {
        return scope.getSortOrder() == SearchSortOrder.TOWARDS_PAST ? RevisionDocInfo.getDateSort() : null;
    }

    private void generateHighlights(List<DiffResult> results) {
        for (DiffResult result : results) {
            for (DiffResult.DiffFile file : result.getFiles()) {
                file.generateHighlight();
            }
        }
    }

    private String findCvsCSID(RepositoryEngine repositoryEngine, String revid) {
        try {
            FileRevision fr = repositoryEngine.getRevisionCache().getFileRevision(Integer.parseInt(revid));
            return fr.getChangeSetId();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (DbException dbException) {
            // empty catch block
        }
        return null;
    }
}

