/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.diffs;

import com.atlassian.fecru.search.changesets.ChangesetResult;
import com.atlassian.fecru.search.diffs.DiffFieldHighlighter;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RepositoryEngine;
import java.util.LinkedList;
import java.util.List;

public class DiffResult
extends ChangesetResult {
    private final RepositoryEngine engine;
    private final List<DiffFile> files = new LinkedList<DiffFile>();

    public DiffResult(RepositoryEngine repositoryEngine, String csid, String displayId) {
        super(repositoryEngine.getName(), csid, displayId);
        this.engine = repositoryEngine;
    }

    public void addFile(String filename, String directory, String revid, DiffFieldHighlighter highlighter) {
        DiffFile file = new DiffFile(filename, directory, revid);
        file.setHighlighter(highlighter);
        this.files.add(file);
    }

    public List<DiffFile> getFiles() {
        return this.files;
    }

    public RepositoryEngine getEngine() {
        return this.engine;
    }

    public static class DiffFile {
        private final String filename;
        private final String directory;
        private final String revid;
        private DiffFieldHighlighter highlighter;
        protected String highlightedAddedText;
        protected String highlightedRemovedText;

        DiffFile(String filename, String directory, String revid) {
            this.filename = filename;
            this.directory = directory;
            this.revid = revid;
        }

        public String getFilename() {
            return this.filename;
        }

        public Path getFullPath() {
            return this.directory == null || this.directory.equals("/") ? new Path("/" + this.filename) : new Path(this.directory + "/" + this.filename);
        }

        public String getRevid() {
            return this.revid;
        }

        public String getHighlightedAddedText() {
            return this.highlightedAddedText;
        }

        public String getHighlightedRemovedText() {
            return this.highlightedRemovedText;
        }

        void setHighlighter(DiffFieldHighlighter highlighter) {
            this.highlighter = highlighter;
        }

        void generateHighlight() {
            this.highlighter.generateFor(this);
        }
    }
}

