/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.content;

import com.atlassian.fecru.search.common.SearchUtils;
import com.atlassian.fecru.search.common.api.QuickSearcher;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.MultiIndexRepositorySearcher;
import com.atlassian.fecru.search.content.ContentHighlighter;
import com.atlassian.fecru.search.content.ContentResult;
import com.atlassian.fecru.search.index.model.ContentDocInfo;
import com.atlassian.fecru.search.index.model.RevisionDocInfo;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.CvsRepositoryEngine;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.RepositoryEngine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.springframework.stereotype.Component;

@Component
public class ContentSearcher
extends MultiIndexRepositorySearcher<ContentResult>
implements QuickSearcher<ContentResult> {
    public ContentSearcher() {
        super(SearchType.CONTENT, LuceneIndexes.CONTENT);
    }

    @Override
    protected Query generateQuery(String userQuery, IndexSearcher searcher, SearchScope scope) {
        return ContentDocInfo.queryByContent(userQuery, scope);
    }

    @Override
    protected SearchResults<ContentResult> buildSearchResults(TopDocs topDocs, SearchScope scope, IndexSearcher searcher, String queryText, Query query) {
        ArrayList<ContentResult> results = new ArrayList<ContentResult>(scope.length());
        for (int i2 = 0; i2 < topDocs.scoreDocs.length; ++i2) {
            ScoreDoc hit = topDocs.scoreDocs[i2];
            try {
                if (!scope.inScope(i2)) continue;
                ContentDocInfo info = ContentDocInfo.CONVERTER.convert(searcher, hit);
                String filename = info.getFilename();
                String directory = info.getDirPath();
                String csid = info.getCsid();
                Date date = info.getTimestamp();
                RepositoryEngine repositoryEngine = this.getRepositoryForDocument(hit.doc, searcher);
                String repository = repositoryEngine.getName();
                if (repositoryEngine instanceof CvsRepositoryEngine) {
                    csid = info.getCvsFileRevision();
                }
                Path path = new Path((directory == null || "/".equals(directory) ? "" : directory) + "/" + filename);
                ContentResult result = new ContentResult(repository, path, csid, date);
                result.setDisplayCsid(SearchUtils.getDisplayId(repositoryEngine.getCfg().getRepositoryType(), csid));
                result.setHighlighter(new ContentHighlighter(searcher, hit.doc, query));
                result.generateHighlight();
                results.add(result);
                continue;
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)("Could not fetch result from index: doc ID " + hit.doc), (Throwable)e2);
            }
        }
        return new SearchResults<ContentResult>(topDocs.totalHits, results, this.getType());
    }

    @Override
    protected Sort getSort(SearchScope scope) {
        return scope.getSortOrder() == SearchSortOrder.TOWARDS_PAST ? RevisionDocInfo.getDateSort() : null;
    }
}

