/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.function.CustomScoreProvider;
import org.apache.lucene.search.function.CustomScoreQuery;

public class RecencyBoostingQuery
extends CustomScoreQuery {
    private final Query query;
    private final float multiplier;
    private final int currentHour;
    private final String timeField;
    private final BoostStrategy strategy;
    public static final BoostStrategy LOG_STRATEGY = new BoostStrategy(){

        @Override
        public double score(int hoursAgo, float multiplier) {
            return 1.0 / Math.log10((float)hoursAgo / multiplier + 3.0f);
        }
    };

    public RecencyBoostingQuery(Query q2, float multiplier, String timeField) {
        super(q2);
        this.query = q2;
        this.currentHour = (int)(System.currentTimeMillis() / 3600000L);
        this.multiplier = multiplier;
        this.timeField = timeField;
        this.strategy = LOG_STRATEGY;
    }

    public CustomScoreProvider getCustomScoreProvider(IndexReader r2) throws IOException {
        return new RecencyBooster(r2, FieldCache.DEFAULT.getInts(r2, this.timeField));
    }

    public Query getOriginalQuery() {
        return this.query;
    }

    public class RecencyBooster
    extends CustomScoreProvider {
        final int[] timestampInHours;

        public RecencyBooster(IndexReader r2, int[] timestampInHours) throws IOException {
            super(r2);
            this.timestampInHours = timestampInHours;
        }

        public float customScore(int doc, float subQueryScore, float valSrcScore) {
            int hoursAgo = Math.max(RecencyBoostingQuery.this.currentHour - this.timestampInHours[doc], 0);
            return (float)((double)subQueryScore * RecencyBoostingQuery.this.strategy.score(hoursAgo, RecencyBoostingQuery.this.multiplier));
        }

        public Explanation customExplain(int doc, Explanation subQueryExpl, Explanation[] valSrcExpls) throws IOException {
            float score = this.customScore(doc, 1.0f, 1.0f);
            int hoursAgo = RecencyBoostingQuery.this.currentHour - this.timestampInHours[doc];
            Explanation explanation = new Explanation(score * subQueryExpl.getValue(), "custom score: product of:");
            explanation.addDetail(new Explanation(score, "recency boost. hours ago: " + hoursAgo));
            explanation.addDetail(subQueryExpl);
            return explanation;
        }
    }

    static interface BoostStrategy {
        public double score(int var1, float var2);
    }
}

