/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.common.lucene.ExactPhraseScorer;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultipleTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.PrefixTermEnum;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class PrefixPhraseQuery
extends Query {
    private final String field;
    private final LinkedList<Term> termPrefixes;

    public PrefixPhraseQuery(String field) {
        this.field = field;
        this.termPrefixes = new LinkedList();
    }

    public void addPrefix(String term) {
        this.termPrefixes.add(new Term(this.field, term));
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.termPrefixes.size() == 1) {
            Term prefix = this.termPrefixes.getFirst();
            return new PrefixQuery(prefix).rewrite(reader);
        }
        return this;
    }

    public void extractTerms(Set<Term> terms) {
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new PrefixPhraseQueryWeigh(searcher);
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof PrefixPhraseQuery)) {
            return false;
        }
        PrefixPhraseQuery query = (PrefixPhraseQuery)((Object)o2);
        return this.field.equals(query.field) && this.termPrefixes.equals(query.termPrefixes);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.termPrefixes.hashCode();
        return result;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder(StringUtils.isEmpty((String)field) ? this.field : field).append(":\"");
        for (Term termPrefix : this.termPrefixes) {
            sb.append(termPrefix.text()).append('*');
        }
        return sb.append('\"').toString();
    }

    public String toString() {
        return this.toString(this.field);
    }

    public boolean hasNoPrefixes() {
        return this.termPrefixes.size() == 0;
    }

    private class PrefixPhraseQueryWeigh
    extends Weight {
        private final Similarity similarity;
        private final float idf;
        private float value;
        private float queryWeight;

        private PrefixPhraseQueryWeigh(Searcher searcher) {
            this.similarity = searcher.getSimilarity();
            this.idf = 1.0f;
        }

        public Query getQuery() {
            return PrefixPhraseQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public float sumOfSquaredWeights() {
            this.queryWeight = this.idf * PrefixPhraseQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float queryNorm) {
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            TermPositions[] termsPos = new TermPositions[PrefixPhraseQuery.this.termPrefixes.size()];
            int[] termsOffset = new int[PrefixPhraseQuery.this.termPrefixes.size()];
            int i2 = 0;
            for (Term prefix : PrefixPhraseQuery.this.termPrefixes) {
                LinkedList<Term> terms = this.getTerms(reader, prefix);
                if (terms.isEmpty()) {
                    return null;
                }
                Object p2 = terms.size() == 1 ? reader.termPositions(terms.getFirst()) : new MultipleTermPositions(reader, terms.toArray(new Term[terms.size()]));
                termsPos[i2] = p2;
                termsOffset[i2] = i2;
                ++i2;
            }
            return new ExactPhraseScorer(this, termsPos, termsOffset, this.similarity, reader.norms(PrefixPhraseQuery.this.field));
        }

        private LinkedList<Term> getTerms(IndexReader reader, Term prefix) throws IOException {
            PrefixTermEnum termEnum = new PrefixTermEnum(reader, prefix);
            LinkedList<Term> terms = new LinkedList<Term>();
            do {
                Term term;
                if ((term = termEnum.term()) == null) continue;
                terms.add(term);
            } while (termEnum.next());
            return terms;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation explanation = new Explanation();
            Explanation weightExplanation = new Explanation(this.value, "queryWeight(" + this.getQuery() + ")");
            explanation.addDetail(weightExplanation);
            Explanation fieldNormExpl = new Explanation();
            byte[] fieldNorms = reader.norms(PrefixPhraseQuery.this.field);
            fieldNormExpl.setDescription("fieldNorm(field=" + PrefixPhraseQuery.this.field + ", doc=" + doc + ")");
            float norm = this.similarity.decodeNormValue(fieldNorms[doc]);
            fieldNormExpl.setValue(norm);
            explanation.addDetail(fieldNormExpl);
            explanation.setValue(this.value * norm);
            explanation.setDescription("Weight(" + this.getQuery() + " in " + doc + "), from:");
            return explanation;
        }
    }
}

