/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.common.lucene.PhrasePositions;
import com.atlassian.fecru.search.common.lucene.PhraseQueue;
import java.io.IOException;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

abstract class PhraseScorer
extends Scorer {
    private final Similarity similarity;
    private Weight weight;
    protected byte[] norms;
    protected float value;
    private boolean firstTime = true;
    private boolean more = true;
    protected PhraseQueue pq;
    protected PhrasePositions first;
    protected PhrasePositions last;
    private float freq;

    PhraseScorer(Weight weight, TermPositions[] tps, int[] offsets, Similarity similarity, byte[] norms) {
        super(weight);
        this.similarity = similarity;
        this.norms = norms;
        this.weight = weight;
        this.value = weight.getValue();
        for (int i2 = 0; i2 < tps.length; ++i2) {
            PhrasePositions pp = new PhrasePositions(tps[i2], offsets[i2]);
            if (this.last != null) {
                this.last.next = pp;
            } else {
                this.first = pp;
            }
            this.last = pp;
        }
        this.pq = new PhraseQueue(tps.length);
        this.first.doc = -1;
    }

    public int docID() {
        return this.first.doc;
    }

    public int nextDoc() throws IOException {
        if (this.firstTime) {
            this.init();
            this.firstTime = false;
        } else if (this.more) {
            this.more = this.last.next();
        }
        if (!this.doNext()) {
            this.first.doc = Integer.MAX_VALUE;
        }
        return this.first.doc;
    }

    private boolean doNext() throws IOException {
        while (this.more) {
            while (this.more && this.first.doc < this.last.doc) {
                this.more = this.first.skipTo(this.last.doc);
                this.firstToLast();
            }
            if (!this.more) continue;
            this.freq = this.phraseFreq();
            if (this.freq == 0.0f) {
                this.more = this.last.next();
                continue;
            }
            return true;
        }
        return false;
    }

    public float score() throws IOException {
        float raw = this.similarity.tf(this.freq) * this.value;
        return this.norms == null ? raw : raw * this.similarity.decodeNormValue(this.norms[this.first.doc]);
    }

    public int advance(int target) throws IOException {
        this.firstTime = false;
        PhrasePositions pp = this.first;
        while (this.more && pp != null) {
            this.more = pp.skipTo(target);
            pp = pp.next;
        }
        if (this.more) {
            this.sort();
        }
        if (!this.doNext()) {
            this.first.doc = Integer.MAX_VALUE;
        }
        return this.first.doc;
    }

    public final float currentFreq() {
        return this.freq;
    }

    protected abstract float phraseFreq() throws IOException;

    private void init() throws IOException {
        PhrasePositions pp = this.first;
        while (this.more && pp != null) {
            this.more = pp.next();
            pp = pp.next;
        }
        if (this.more) {
            this.sort();
        }
    }

    private void sort() {
        this.pq.clear();
        PhrasePositions pp = this.first;
        while (pp != null) {
            this.pq.add(pp);
            pp = pp.next;
        }
        this.pqToList();
    }

    protected final void pqToList() {
        this.first = null;
        this.last = null;
        while (this.pq.top() != null) {
            PhrasePositions pp = (PhrasePositions)this.pq.pop();
            if (this.last != null) {
                this.last.next = pp;
            } else {
                this.first = pp;
            }
            this.last = pp;
            pp.next = null;
        }
    }

    protected final void firstToLast() {
        this.last.next = this.first;
        this.last = this.first;
        this.first = this.first.next;
        this.last.next = null;
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

