/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.common.api.SearchResult;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.FishEyeQuickSearcher;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.lucene.searcher.MultiRepositoryIndexReader;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;

public abstract class MultiIndexRepositorySearcher<T extends SearchResult>
extends FishEyeQuickSearcher<T, IndexSearcher> {
    protected MultiIndexRepositorySearcher(SearchType type, LuceneIndexes index) {
        super(type, index);
    }

    @Override
    protected IndexSearcher getSearcher(SearchScope scope) throws IOException {
        ImmutableMap.Builder leakedReadersBuilder = ImmutableMap.builder();
        for (RepositoryHandle handle : scope.getRepositories()) {
            Map.Entry<IndexReader, RepositoryEngine> entry = this.openReader(handle);
            if (entry == null) continue;
            leakedReadersBuilder.put(entry);
        }
        return new IndexSearcher((IndexReader)new MultiRepositoryIndexReader((Map<IndexReader, RepositoryEngine>)leakedReadersBuilder.build()));
    }

    protected Map.Entry<IndexReader, RepositoryEngine> openReader(RepositoryHandle handle) {
        RepositoryEngine engine;
        try {
            engine = handle.acquireEngine();
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.debug((Object)("Couldn't acquire " + handle.getName() + ", omitting in search"));
            return null;
        }
        LuceneConnection<LuceneIndexes> luceneConnection = engine.getIndexConnection();
        IndexReader reader = luceneConnection.leakIndexReader((LuceneIndexes)this.index);
        return new AbstractMap.SimpleEntry<IndexReader, RepositoryEngine>(reader, engine);
    }

    protected final RepositoryEngine getRepositoryForDocument(int docId, IndexSearcher multiSearcher) {
        return ((MultiRepositoryIndexReader)multiSearcher.getIndexReader()).getRepositoryEngineForDoc(docId);
    }

    @Override
    protected void cleanup(IndexSearcher multiSearcher) {
        if (multiSearcher != null) {
            try {
                multiSearcher.getIndexReader().close();
            }
            catch (IOException e2) {
                Logs.APP_LOG.warn((Object)("Error closing repository searcher: " + e2), (Throwable)e2);
            }
        }
    }
}

