/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.common.lucene.PrefixPhraseQuery;
import com.atlassian.fecru.search.common.lucene.TokenStreamVisitor;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LimitTokenCountAnalyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Version;

public final class LuceneUtils {
    private LuceneUtils() {
    }

    public static void initBooleanQueryClauseCount() {
        BooleanQuery.setMaxClauseCount((int)FishEyeSysProps.LUCENE_BOOLEAN_QUERY_MAX_CLAUSE_COUNT);
    }

    public static Query generateParsedQuery(String userQuery, String fieldName, Analyzer analyzer) {
        while (userQuery.length() > 1 && (userQuery.charAt(0) == '*' || userQuery.charAt(0) == '?')) {
            userQuery = userQuery.substring(1);
        }
        QueryParser queryParser = new QueryParser(Version.LUCENE_30, fieldName, analyzer);
        try {
            return queryParser.parse(userQuery);
        }
        catch (ParseException e2) {
            Logs.APP_LOG.debug((Object)("Could not parse user query: " + userQuery), (Throwable)e2);
            return LuceneUtils.generatePhraseQuery(userQuery, fieldName, analyzer);
        }
    }

    public static PhraseQuery generatePhraseQuery(String text, final String fieldName, Analyzer analyser) {
        final PhraseQuery phraseQuery = new PhraseQuery();
        LuceneUtils.visitTokens(text, fieldName, analyser, new TokenStreamVisitor(){

            @Override
            public void visit(String term) {
                phraseQuery.add(new Term(fieldName, term));
            }
        });
        return phraseQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitTokens(String text, String fieldName, Analyzer analyser, TokenStreamVisitor visitor) {
        TokenStream tokenStream = null;
        try {
            tokenStream = analyser.reusableTokenStream(fieldName, (Reader)new StringReader(text));
            CharTermAttribute term = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
            while (tokenStream.incrementToken()) {
                visitor.visit(term.toString());
            }
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)("Could not tokenize string: " + text), (Throwable)e2);
        }
        finally {
            try {
                if (tokenStream != null) {
                    tokenStream.close();
                }
            }
            catch (IOException e3) {
                Logs.APP_LOG.error((Object)("Could not close token stream for: " + text), (Throwable)e3);
            }
        }
    }

    public static FieldSelector singleFieldSelector(final String fieldName) {
        return new FieldSelector(){

            public FieldSelectorResult accept(String field) {
                if (fieldName.equals(field)) {
                    return FieldSelectorResult.LOAD_AND_BREAK;
                }
                return FieldSelectorResult.NO_LOAD;
            }
        };
    }

    public static FieldSelector multipleFieldsSelector(String ... fieldNames) {
        return new SetBasedFieldSelector((Set)ImmutableSet.copyOf((Object[])fieldNames), (Set)ImmutableSet.of());
    }

    public static PhraseQuery parsePhrase(String query, String field, Analyzer analyzer) {
        PhraseQuery pq = new PhraseQuery();
        TokenStream ts = analyzer.tokenStream(field, (Reader)new StringReader(query));
        boolean haveAdded = false;
        try {
            TermAttribute termAttr = (TermAttribute)ts.addAttribute(TermAttribute.class);
            while (ts.incrementToken()) {
                Term t2 = new Term(field, termAttr.term());
                pq.add(t2);
                haveAdded = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!haveAdded) {
            Logs.APP_LOG.info((Object)("phrase tokenization resulted in no tokens: " + query));
            pq.add(new Term(field, query));
        }
        return pq;
    }

    public static Query matchAnyTokens(Analyzer ana, String field, String query, boolean matchPrefix) {
        return LuceneUtils.matchTokens(ana, field, query, matchPrefix, BooleanClause.Occur.SHOULD);
    }

    private static Query matchTokens(Analyzer ana, String field, String query, boolean matchPrefix, BooleanClause.Occur occur) {
        BooleanQuery q2 = new BooleanQuery();
        TokenStream ts = ana.tokenStream(field, (Reader)new StringReader(query));
        boolean haveAdded = false;
        try {
            TermAttribute termAttr = (TermAttribute)ts.addAttribute(TermAttribute.class);
            while (ts.incrementToken()) {
                Term t2 = new Term(field, termAttr.term());
                q2.add((Query)(matchPrefix ? new PrefixQuery(t2) : new TermQuery(t2)), occur);
                haveAdded = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!haveAdded) {
            Logs.APP_LOG.info((Object)("phrase tokenization resulted in no tokens: " + query));
            return new TermQuery(new Term(field, query));
        }
        return q2;
    }

    public static Query matchAllTokens(Analyzer ana, String field, String query, boolean matchPrefix) {
        return LuceneUtils.matchTokens(ana, field, query, matchPrefix, BooleanClause.Occur.MUST);
    }

    public static Query generatePrefixPhraseQuery(String query, String fieldName, Analyzer analyser) {
        final PrefixPhraseQuery phraseQuery = new PrefixPhraseQuery(fieldName);
        final MutableInt termCount = new MutableInt(0);
        LuceneUtils.visitTokens(query, fieldName, analyser, new TokenStreamVisitor(){

            @Override
            public void visit(String term) {
                phraseQuery.addPrefix(term);
                termCount.setValue(termCount.intValue() + 1);
            }
        });
        if (termCount.intValue() == 1) {
            return new PrefixQuery(new Term(fieldName, query));
        }
        return phraseQuery;
    }

    public static Analyzer createPerFieldAnalyzer(Analyzer defaultAnalyzer) {
        return LuceneUtils.createPerFieldAnalyzer(defaultAnalyzer, Collections.emptyMap());
    }

    public static Analyzer createPerFieldAnalyzer(Analyzer defaultAnalyzer, Map<String, Analyzer> perFieldAnalyzers) {
        return new LimitTokenCountAnalyzer((Analyzer)new PerFieldAnalyzerWrapper(defaultAnalyzer, perFieldAnalyzers), 1000000);
    }
}

