/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.common.lucene.RecencyBoostingQuery;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;

public abstract class LuceneHighlighter {
    private static final int MAX_NUM_FRAGMENTS = 3;
    private final Query query;

    protected LuceneHighlighter(Query query) {
        this.query = LuceneHighlighter.removeCustomScoring(query);
    }

    protected String highlight(String text, TokenStream tokenStream, String separator) {
        try {
            Highlighter highlighter = this.getHighlighter();
            tokenStream.reset();
            return highlighter.getBestFragments(tokenStream, text, 3, separator);
        }
        catch (IOException e2) {
            Logs.APP_LOG.debug((Object)("Could not generate highlight for text: " + text), (Throwable)e2);
            return "";
        }
        catch (InvalidTokenOffsetsException e3) {
            Logs.APP_LOG.debug((Object)("Could not generate highlight for text: " + text), (Throwable)e3);
            return "";
        }
    }

    protected Highlighter getHighlighter() {
        return new Highlighter((Formatter)new SimpleHTMLFormatter("<span class=\"matched-text\">", "</span>"), (Encoder)new SimpleHTMLEncoder(), (Scorer)new QueryScorer(this.query));
    }

    public static Query removeCustomScoring(Query query) {
        if (query instanceof RecencyBoostingQuery) {
            return ((RecencyBoostingQuery)query).getOriginalQuery();
        }
        if (query instanceof BooleanQuery) {
            BooleanQuery originalQuery = (BooleanQuery)query;
            BooleanQuery transformedQuery = new BooleanQuery(originalQuery.isCoordDisabled());
            for (BooleanClause clause : originalQuery.getClauses()) {
                transformedQuery.add(LuceneHighlighter.removeCustomScoring(clause.getQuery()), clause.getOccur());
            }
            return transformedQuery;
        }
        return query;
    }
}

