/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.common.api.SearchResult;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.LuceneSearcher;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;

public abstract class FishEyeQuickSearcher<T extends SearchResult, S extends IndexSearcher>
extends LuceneSearcher {
    public static final String ATTR_REPO_NAME = "repository-name";
    protected final LuceneConnection.IndexConfig index;
    private final SearchType type;

    protected FishEyeQuickSearcher(SearchType type, LuceneConnection.IndexConfig index) {
        this.type = type;
        this.index = index;
    }

    public final SearchType getType() {
        return this.type;
    }

    public final LuceneConnection.IndexConfig getIndex() {
        return this.index;
    }

    protected abstract Query generateQuery(String var1, S var2, SearchScope var3);

    protected abstract SearchResults<T> buildSearchResults(TopDocs var1, SearchScope var2, S var3, String var4, Query var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SearchResults<T> search(String userText, SearchScope scope) {
        if (scope.getRepositories() == null) {
            throw new IllegalStateException("Repository Engines not configured. setRepositories must be set prior to performing a search.");
        }
        if (scope.getRepositories().isEmpty()) {
            return new SearchResults(0, Collections.emptyList(), this.getType());
        }
        S searcher = null;
        try {
            searcher = this.getSearcher(scope);
            Query query = this.generateQuery(userText, searcher, scope);
            if (scope.isCountOnly()) {
                TotalHitCountCollector collector = new TotalHitCountCollector();
                searcher.search(query, null, (Collector)collector);
                SearchResults searchResults = new SearchResults(collector.getTotalHits(), this.getType());
                return searchResults;
            }
            TopDocs docs = this.doSearch((IndexSearcher)searcher, query, this.getMaxResults(scope), this.getSort(scope));
            SearchResults<T> searchResults = this.buildSearchResults(docs, scope, searcher, userText, query);
            return searchResults;
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)("Can not open index searcher for indexes: " + this.index), (Throwable)e2);
            SearchResults<T> searchResults = null;
            return searchResults;
        }
        finally {
            this.cleanup(searcher);
        }
    }

    protected Sort getSort(SearchScope scope) {
        return null;
    }

    protected abstract S getSearcher(SearchScope var1) throws IOException;

    protected int getMaxResults(SearchScope scope) {
        return scope.to();
    }

    protected abstract void cleanup(@Nullable S var1);
}

