/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.common.lucene.LuceneHighlighter;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.search.quicksearch2.TokenSources;
import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.commons.lang.WordUtils;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;

public abstract class FieldHighlighter
extends LuceneHighlighter {
    private static final int MAX_NUMBER_OF_TERMS_IN_VECTOR = 1000;
    private final IndexSearcher searcher;
    private final int docId;

    protected FieldHighlighter(IndexSearcher searcher, int docId, Query query) {
        super(query);
        this.searcher = searcher;
        this.docId = docId;
    }

    protected String highlight(String field) {
        TermPositionVector termPositionVector = this.getTermPositionVector(field);
        if (termPositionVector == null || termPositionVector.size() > 1000) {
            return "";
        }
        TokenStream tokenStream = TokenSources.getTokenStream(termPositionVector);
        if (tokenStream == null) {
            return "";
        }
        String text = this.reconstructOriginalText(tokenStream);
        String highlight = this.highlight(text, tokenStream, "...");
        if (!Strings.isNullOrEmpty((String)highlight)) {
            return highlight;
        }
        return new SimpleHTMLEncoder().encodeText(WordUtils.abbreviate((String)text, (int)120, (int)-1, (String)"..."));
    }

    private TermPositionVector getTermPositionVector(String field) {
        try {
            TermFreqVector freqVector = this.searcher.getIndexReader().getTermFreqVector(this.docId, field);
            if (freqVector != null && freqVector instanceof TermPositionVector) {
                TermPositionVector tfp = (TermPositionVector)freqVector;
                return tfp;
            }
        }
        catch (IOException e2) {
            Logs.APP_LOG.debug((Object)("Could not get the TFV for field " + field), (Throwable)e2);
        }
        return null;
    }

    private String reconstructOriginalText(TokenStream tokens) {
        try {
            tokens.reset();
            StringBuilder sb = new StringBuilder();
            OffsetAttribute offset = (OffsetAttribute)tokens.addAttribute(OffsetAttribute.class);
            CharTermAttribute term = (CharTermAttribute)tokens.addAttribute(CharTermAttribute.class);
            while (tokens.incrementToken()) {
                while (sb.length() < offset.startOffset()) {
                    sb.append(' ');
                }
                sb.replace(offset.startOffset(), offset.endOffset(), term.toString());
            }
            return sb.toString();
        }
        catch (IOException e2) {
            Logs.APP_LOG.debug((Object)"Could not reconstruct text for document", (Throwable)e2);
            return "";
        }
    }
}

