/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fugue.Option;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Map;

public class CrossRepoSearcherState {
    private final Map<String, RepositoryHandle> includeRepos;
    private final Collection<String> excludeRepos;
    private final LoadingCache<String, Option<RepositoryEngine>> engines;

    public CrossRepoSearcherState(final Map<String, RepositoryHandle> includeRepos, Collection<String> excludeRepos) {
        this.includeRepos = includeRepos;
        this.excludeRepos = excludeRepos;
        this.engines = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Option<RepositoryEngine>>(){

            public Option<RepositoryEngine> load(String repositoryName) {
                try {
                    RepositoryHandle handle = (RepositoryHandle)includeRepos.get(repositoryName);
                    if (handle != null) {
                        return Option.some((Object)handle.acquireEngine());
                    }
                }
                catch (RepositoryHandle.StateException e2) {
                    Logs.APP_LOG.debug((Object)("Couldn't acquire an repository: " + repositoryName + ", ignoring it."));
                }
                return Option.none();
            }
        });
    }

    public Collection<String> getIncludeRepos() {
        return this.includeRepos.keySet();
    }

    public Collection<String> getExcludeRepos() {
        return this.excludeRepos;
    }

    public void invalidateCache() {
        this.engines.invalidateAll();
    }

    public Option<RepositoryEngine> getEngine(String repository) {
        return (Option)this.engines.getUnchecked((Object)repository);
    }
}

