/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.common.api.SearchResult;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.CrossRepoSearcherState;
import com.atlassian.fecru.search.common.lucene.FishEyeQuickSearcher;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.searcher.PayloadIndexSearcher;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sun.istack.Nullable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;

public abstract class CrossRepoSearcher<T extends SearchResult>
extends FishEyeQuickSearcher<T, PayloadIndexSearcher<CrossRepoSearcherState>> {
    private static final String SEARCHER_STATE_ATTR = CrossRepoSearcherState.class.getName();
    private final RepositoryManager repositoryManager;
    private final CrossRepLuceneIndex crossRepLuceneIndex;

    protected CrossRepoSearcher(SearchType type, LuceneConnection.IndexConfig index, RepositoryManager repositoryManager, CrossRepLuceneIndex crossRepLuceneIndex) {
        super(type, index);
        this.repositoryManager = repositoryManager;
        this.crossRepLuceneIndex = crossRepLuceneIndex;
    }

    @Override
    protected Query generateQuery(String userQuery, PayloadIndexSearcher<CrossRepoSearcherState> searcher, SearchScope scope) {
        CrossRepoSearcherState state = CrossRepoSearcher.getSearcherState(searcher);
        try {
            return this.generateQuery(userQuery, searcher, scope, state);
        }
        catch (IOException e2) {
            Logs.APP_LOG.info((Object)("Could not create query for " + userQuery + " " + e2.getMessage()), (Throwable)e2);
            return null;
        }
    }

    protected abstract Query generateQuery(String var1, PayloadIndexSearcher<CrossRepoSearcherState> var2, SearchScope var3, CrossRepoSearcherState var4) throws IOException;

    @Override
    protected PayloadIndexSearcher<CrossRepoSearcherState> getSearcher(SearchScope scope) throws IOException {
        Map<String, RepositoryHandle> searchRepos = scope.getRepositoriesMap();
        ImmutableSet dontSearchRepos = ImmutableSet.copyOf((Collection)Sets.difference(this.repositoryManager.getHandleMap().keySet(), searchRepos.keySet()));
        PayloadIndexSearcher<CrossRepoSearcherState> searcher = new PayloadIndexSearcher<CrossRepoSearcherState>(this.getIndexReader());
        CrossRepoSearcher.setSearcherState(searcher, new CrossRepoSearcherState(searchRepos, (Collection<String>)dontSearchRepos));
        return searcher;
    }

    private static void setSearcherState(PayloadIndexSearcher<CrossRepoSearcherState> searcher, CrossRepoSearcherState state) {
        searcher.addAttribute(SEARCHER_STATE_ATTR, state);
    }

    @Override
    protected void cleanup(@Nullable PayloadIndexSearcher<CrossRepoSearcherState> searcher) {
        if (searcher != null) {
            try {
                searcher.getIndexReader().decRef();
            }
            catch (IOException e2) {
                Logs.APP_LOG.warn((Object)"Error releasing IndexSearcher for CommitterSearcher");
            }
            CrossRepoSearcher.getSearcherState(searcher).invalidateCache();
        }
    }

    public static CrossRepoSearcherState getSearcherState(PayloadIndexSearcher<CrossRepoSearcherState> searcher) {
        return searcher.getAttribute(SEARCHER_STATE_ATTR);
    }

    protected IndexReader getIndexReader() {
        return this.crossRepLuceneIndex.getConnection().leakIndexReader(CrossRepLuceneIndexes.METADATA);
    }
}

