/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.cenqua.fisheye.util.AntGlob;
import java.io.IOException;
import org.apache.commons.lang.Validate;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;

public final class AntGlobQuery
extends MultiTermQuery {
    private final Term antGlobPattern;

    public AntGlobQuery(Term antGlobPattern) {
        Validate.notNull((Object)antGlobPattern);
        this.antGlobPattern = antGlobPattern;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new AntGlobEnum(reader, this.antGlobPattern);
    }

    public String toString(String field) {
        return this.antGlobPattern.toString();
    }

    private static class AntGlobEnum
    extends FilteredTermEnum {
        private final String field;
        private final AntGlob antGlob;
        private boolean end = false;

        public AntGlobEnum(IndexReader reader, Term term) throws IOException {
            String pattern = term.text();
            int prefixPos = this.getFirstWildcard(pattern);
            this.field = term.field();
            this.antGlob = new AntGlob(pattern, false);
            if (prefixPos > 0) {
                String prefix = pattern.substring(0, prefixPos);
                this.setEnum(reader.terms(new Term(term.field(), prefix)));
            } else if (prefixPos == 0) {
                this.setEnum(reader.terms(new Term(term.field())));
            } else {
                this.setEnum(reader.terms(term));
            }
        }

        private int getFirstWildcard(String pattern) {
            int posStar = pattern.indexOf(42);
            int posQuestionMark = pattern.indexOf(63);
            if (posQuestionMark == -1 && posStar >= 0) {
                return posStar;
            }
            if (posStar == -1 && posQuestionMark >= 0) {
                return posQuestionMark;
            }
            return Math.min(posQuestionMark, posStar);
        }

        protected boolean termCompare(Term term) {
            if (this.field != term.field()) {
                this.end = true;
                return false;
            }
            return this.antGlob.matches(term.text());
        }

        public float difference() {
            return 1.0f;
        }

        protected boolean endEnum() {
            return this.end;
        }
    }
}

