/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.highlighting;

import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikiHighlighter {
    private static final Pattern TAGS = Pattern.compile("<[^>]+?>");
    private static final Pattern TERM_SEPARATOR = Pattern.compile("\\s+");
    private static final String[] DEFAULT_HIGHLIGHT_WRAPPER = new String[]{"<span class=\"matched-text\">", "</span>"};
    protected final WikiRenderer wikiRenderer;

    protected WikiHighlighter(WikiRenderer wikiRenderer) {
        this.wikiRenderer = wikiRenderer;
    }

    protected String highlight(String text, String queryText, RenderContext context, boolean returnNullIfNoHits) {
        if (text == null) {
            return null;
        }
        String wikiRenderedText = this.wikiRenderer.render((CharSequence)text, context);
        List<int[]> tagsPos = this.getTagPositions(wikiRenderedText);
        List<int[]> matchesPos = this.getMatchPositions(wikiRenderedText, queryText);
        List<int[]> actualMatchesPos = this.getMatchOutsideTags(tagsPos, matchesPos);
        this.sortMatches(actualMatchesPos);
        this.removeOverlappingMatches(actualMatchesPos);
        return actualMatchesPos.isEmpty() && returnNullIfNoHits ? null : this.wrapMatch(wikiRenderedText, actualMatchesPos);
    }

    private List<int[]> getTagPositions(String wikiRenderedText) {
        Matcher matcher = TAGS.matcher(wikiRenderedText);
        LinkedList<int[]> pos = new LinkedList<int[]>();
        while (matcher.find()) {
            pos.add(new int[]{matcher.start(), matcher.end()});
        }
        return pos;
    }

    private List<int[]> getMatchPositions(String wikiRenderedText, String query) {
        String[] terms = this.getTerms(query);
        String text = wikiRenderedText.toLowerCase();
        LinkedList<int[]> pos = new LinkedList<int[]>();
        for (String term : terms) {
            int start = 0;
            while (term.length() != 0 && (start = text.indexOf(term, start)) != -1) {
                pos.add(new int[]{start, start += term.length()});
            }
        }
        return pos;
    }

    private List<int[]> getMatchOutsideTags(List<int[]> tagsPos, List<int[]> matchesPos) {
        Iterator<int[]> iterator = matchesPos.iterator();
        while (iterator.hasNext()) {
            int[] match = iterator.next();
            int startMatch = match[0];
            int endMatch = match[1];
            for (int[] tag : tagsPos) {
                int startTag = tag[0];
                int endTag = tag[1];
                if (startTag >= endMatch || endTag <= startMatch) continue;
                iterator.remove();
            }
        }
        return matchesPos;
    }

    private void sortMatches(List<int[]> matches) {
        Collections.sort(matches, new Comparator<int[]>(){

            @Override
            public int compare(int[] match1, int[] match2) {
                if (match1[0] < match2[0]) {
                    return -1;
                }
                if (match1[0] == match2[0]) {
                    return 0;
                }
                return 1;
            }
        });
    }

    private void removeOverlappingMatches(List<int[]> matches) {
        ListIterator<int[]> iterator = matches.listIterator();
        block0: while (iterator.hasNext()) {
            int[] match1 = iterator.next();
            while (iterator.hasNext()) {
                int[] match2 = iterator.next();
                int end1 = match1[1];
                int start2 = match2[0];
                int end2 = match2[1];
                if (end1 <= start2) {
                    iterator.previous();
                    continue block0;
                }
                match1[1] = Math.max(end1, end2);
                iterator.remove();
            }
        }
    }

    private String wrapMatch(String wikiRenderedText, List<int[]> actualMatchesPos) {
        StringBuilder sb = new StringBuilder(wikiRenderedText);
        int matched = 0;
        int offset = DEFAULT_HIGHLIGHT_WRAPPER[0].length() + DEFAULT_HIGHLIGHT_WRAPPER[1].length();
        for (int[] match : actualMatchesPos) {
            int startMatch = match[0] + offset * matched;
            int endMatch = match[1] + offset * matched + DEFAULT_HIGHLIGHT_WRAPPER[0].length();
            sb.insert(startMatch, DEFAULT_HIGHLIGHT_WRAPPER[0]);
            sb.insert(endMatch, DEFAULT_HIGHLIGHT_WRAPPER[1]);
            ++matched;
        }
        return sb.toString();
    }

    private String[] getTerms(String query) {
        String escapedQueryText = HtmlEscaper.escapeAll((String)query, (boolean)false).toLowerCase();
        return TERM_SEPARATOR.split(escapedQueryText);
    }
}

