/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.highlighting;

import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

public class SimpleHighlighter {
    private static final Pattern TERM_SEPARATOR = Pattern.compile("\\W+");
    private static final String[] DEFAULT_HIGHLIGHT_WRAPPER = new String[]{"<span class=\"matched-text\">", "</span>"};
    private final String searchTerms;
    private final String[] highlightWrapper;

    public SimpleHighlighter(String searchTerms) {
        this(searchTerms, DEFAULT_HIGHLIGHT_WRAPPER);
    }

    public SimpleHighlighter(String searchTerms, String[] highlightWrapper) {
        this.searchTerms = searchTerms;
        this.highlightWrapper = highlightWrapper;
        if (highlightWrapper.length != 2) {
            throw new IllegalArgumentException("Incorrect wrapper: should have pre and post wrapper, but was:" + Arrays.toString(highlightWrapper));
        }
    }

    public String highlight(String text) {
        String[] terms = this.getTerms();
        String lowercase = text.toLowerCase();
        StringBuilder out = new StringBuilder();
        int pos = 0;
        for (String term : terms) {
            int posTerm = text.indexOf(term, pos);
            if (posTerm == -1) {
                posTerm = lowercase.indexOf(term.toLowerCase(), pos);
            }
            if (posTerm == -1) break;
            this.wrapUnhighlighted(out, text.substring(pos, posTerm));
            pos = posTerm + term.length();
            this.wrapHighlighted(out, text.substring(posTerm, pos));
        }
        if (pos < text.length()) {
            this.wrapUnhighlighted(out, text.substring(pos));
        }
        return out.toString();
    }

    private String[] getTerms() {
        String[] terms = TERM_SEPARATOR.split(this.searchTerms);
        ArrayList<String> list = new ArrayList<String>(terms.length);
        for (String term : terms) {
            String trim = term.trim();
            if (trim.length() <= 0) continue;
            list.add(trim);
        }
        return list.toArray(new String[list.size()]);
    }

    private void wrapUnhighlighted(StringBuilder out, String s2) {
        out.append(this.escape(s2));
    }

    private void wrapHighlighted(StringBuilder out, String s2) {
        out.append(this.highlightWrapper[0]).append(this.escape(s2)).append(this.highlightWrapper[1]);
    }

    private String escape(String s2) {
        return ExpressionUtil.escapeString(s2);
    }
}

