/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.api;

import com.atlassian.fecru.search.common.api.SearchGroup;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

public enum SearchType {
    FILE_PATHS(SearchGroup.SOURCE, "Files and directories", "File or directory", "file", true, false, SearchSortOrder.BY_SCORE, SearchSortOrder.TOWARDS_PAST),
    CHANGESET_COMMENTS(SearchGroup.SOURCE, "Commit messages", "Commit message", "commit", false, false, SearchSortOrder.BY_SCORE, SearchSortOrder.TOWARDS_PAST),
    CHANGESET_DIFFS(SearchGroup.SOURCE, "Diffs", "Diff", "diff", true, true, SearchSortOrder.BY_SCORE, SearchSortOrder.TOWARDS_PAST),
    CONTENT(SearchGroup.SOURCE, "Content", "Content", "content", true, true, SearchSortOrder.BY_SCORE, SearchSortOrder.TOWARDS_PAST),
    COMMITTERS(SearchGroup.SOURCE, "Committers", "Committer", "committer", false, false, new SearchSortOrder[0]),
    REVIEW_DETAILS(SearchGroup.REVIEWS, "Reviews", "Review", "detail", false, false, SearchSortOrder.BY_SCORE, SearchSortOrder.TOWARDS_PAST),
    REVIEW_COMMENTS(SearchGroup.REVIEWS, "Comments", "Comment", "reviewcomment", false, false, SearchSortOrder.BY_SCORE, SearchSortOrder.TOWARDS_PAST),
    REPOSITORIES(SearchGroup.QUICKNAV, "Repositories", "Repository", null, false, false, new SearchSortOrder[0]),
    PROJECTS(SearchGroup.QUICKNAV, "Projects", "Project", null, false, false, new SearchSortOrder[0]),
    USERS(SearchGroup.QUICKNAV, "Users", "User", null, false, false, new SearchSortOrder[0]);

    public static final List<SearchType> ALL_SEARCH_TYPES;
    private final SearchGroup group;
    private final String descriptionPlural;
    private final String descriptionSingular;
    private final String hint;
    private final boolean affectedByRepositoryIndexing;
    private final boolean limitRepositoryCount;
    private final SearchSortOrder[] sortOrders;

    private SearchType(SearchGroup group, String descriptionPlural, String descriptionSingular, String hint, boolean affectedByRepositoryIndexing, boolean limitRepositoryCount, SearchSortOrder ... sortOrders) {
        SearchSortOrder[] searchSortOrderArray;
        this.group = group;
        this.descriptionPlural = descriptionPlural;
        this.descriptionSingular = descriptionSingular;
        this.hint = hint;
        this.affectedByRepositoryIndexing = affectedByRepositoryIndexing;
        this.limitRepositoryCount = limitRepositoryCount;
        if (sortOrders.length == 0) {
            SearchSortOrder[] searchSortOrderArray2 = new SearchSortOrder[1];
            searchSortOrderArray = searchSortOrderArray2;
            searchSortOrderArray2[0] = SearchSortOrder.BY_SCORE;
        } else {
            searchSortOrderArray = sortOrders;
        }
        this.sortOrders = searchSortOrderArray;
    }

    public String getName() {
        return this.name();
    }

    public SearchType[] getValues() {
        return SearchType.values();
    }

    public String getDescriptionSingular() {
        return this.descriptionSingular;
    }

    public String getDescriptionPlural() {
        return this.descriptionPlural;
    }

    @Nullable
    public String getHint() {
        return this.hint;
    }

    public boolean isLimitRepositoryCount() {
        return this.limitRepositoryCount;
    }

    public String getOrdinal() {
        return Integer.toString(this.ordinal());
    }

    public SearchGroup getGroup() {
        return this.group;
    }

    public static SearchType byHint(String s2) {
        for (SearchType searchType : SearchType.values()) {
            if (!searchType.hint.equalsIgnoreCase(s2)) continue;
            return searchType;
        }
        return null;
    }

    public boolean isAffectedByRepositoryIndexing() {
        return this.affectedByRepositoryIndexing;
    }

    public SearchSortOrder[] getSortOrders() {
        return this.sortOrders;
    }

    static {
        ALL_SEARCH_TYPES = ImmutableList.copyOf((Object[])SearchType.values());
    }
}

