/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.api;

import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fisheye.quicksearch.action.HintParser;
import com.atlassian.fisheye.quicksearch.action.Licenses;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class SearchScope {
    private final int from;
    private final int to;
    private final boolean countOnly;
    private final List<RepositoryHandle> repositories;
    @Nullable
    private final String projectKey;
    private final SearchSortOrder sortOrder;
    private final HintParser hints;
    private final boolean details;
    private Map<String, RepositoryHandle> repositoriesMap;
    private final boolean highlights;
    private final QuickSearchTimeBucket timeBucket;
    private final String user;

    private SearchScope(int from, int to, boolean countOnly, SearchSortOrder sortOrder, HintParser hints, List<RepositoryHandle> repositories, @Nullable String projectKey, boolean highlights, boolean details, QuickSearchTimeBucket timeBucket, String user) {
        this.highlights = highlights;
        this.sortOrder = sortOrder;
        this.hints = hints;
        this.projectKey = projectKey;
        this.repositories = repositories;
        this.countOnly = countOnly;
        this.to = to;
        this.from = from;
        this.timeBucket = timeBucket;
        this.user = user;
        this.details = details;
    }

    public int from() {
        return this.from;
    }

    public int to() {
        return this.to;
    }

    public int length() {
        int n2 = this.to - this.from;
        return n2 > 0 ? n2 : 0;
    }

    public boolean inScope(int i2) {
        return i2 >= this.from && i2 < this.to;
    }

    public boolean isCountOnly() {
        return this.countOnly;
    }

    public List<RepositoryHandle> getRepositories() {
        return this.repositories;
    }

    @Nullable
    public String getProjectKey() {
        return this.projectKey;
    }

    public SearchSortOrder getSortOrder() {
        return this.sortOrder;
    }

    public HintParser getHints() {
        return this.hints;
    }

    public RepositoryHandle getRepositoryForName(String name) {
        return this.getRepositoriesMap().get(name);
    }

    public Map<String, RepositoryHandle> getRepositoriesMap() {
        if (null == this.repositoriesMap) {
            this.repositoriesMap = Maps.uniqueIndex(this.getRepositories(), RepositoryHandle.TO_REPO_NAME);
        }
        return this.repositoriesMap;
    }

    public boolean isHighlights() {
        return this.highlights;
    }

    public QuickSearchTimeBucket getTimeBucket() {
        return this.timeBucket;
    }

    public String getUser() {
        return this.user;
    }

    public static SearchScopeBuilder builder() {
        return new SearchScopeBuilder();
    }

    public boolean isDetails() {
        return this.details;
    }

    public static class SearchScopeBuilder {
        private int from = 0;
        private int to = 10;
        private boolean countOnly = false;
        private List<RepositoryHandle> repositories = Collections.emptyList();
        private SearchSortOrder sortOrder = SearchSortOrder.BY_SCORE;
        private HintParser hints = new HintParser(Licenses.allowedSearchTypes());
        private boolean highlights = false;
        private QuickSearchTimeBucket timeBucket = QuickSearchTimeBucket.ANY_DATE;
        private String user;
        private boolean details = true;
        @Nullable
        private String projectKey;

        public SearchScopeBuilder withHighlights(boolean highlights) {
            this.highlights = highlights;
            return this;
        }

        public SearchScopeBuilder withSort(SearchSortOrder sortOrder) {
            Preconditions.checkNotNull((Object)((Object)sortOrder));
            this.sortOrder = sortOrder;
            return this;
        }

        public SearchScopeBuilder withTimeBucket(QuickSearchTimeBucket timeBucket) {
            Preconditions.checkNotNull((Object)((Object)timeBucket));
            this.timeBucket = timeBucket;
            return this;
        }

        public SearchScopeBuilder withCountOnly(boolean countOnly) {
            this.countOnly = countOnly;
            return this;
        }

        public SearchScopeBuilder withFrom(int from) {
            Preconditions.checkArgument((from >= 0 ? 1 : 0) != 0, (Object)"From should be a non-negative number");
            this.from = from;
            return this;
        }

        public SearchScopeBuilder withTo(int to) {
            Preconditions.checkArgument((to >= 0 ? 1 : 0) != 0, (Object)"To should be a non-negative number");
            this.to = to;
            return this;
        }

        public SearchScopeBuilder withHints(HintParser hints) {
            Preconditions.checkNotNull((Object)hints);
            this.hints = hints;
            return this;
        }

        public SearchScopeBuilder withRepositories(RepositoryHandle ... repositories) {
            Preconditions.checkNotNull((Object)repositories);
            this.repositories = ImmutableList.copyOf((Object[])repositories);
            return this;
        }

        public SearchScopeBuilder withRepositories(Iterable<RepositoryHandle> repositories) {
            Preconditions.checkNotNull(repositories);
            this.repositories = ImmutableList.copyOf(repositories);
            return this;
        }

        public SearchScopeBuilder withProjectKey(@Nullable String projectKey) {
            this.projectKey = Strings.nullToEmpty((String)projectKey);
            return this;
        }

        public SearchScopeBuilder withUser(String user) {
            this.user = user;
            return this;
        }

        public SearchScopeBuilder withDetails(boolean details) {
            this.details = details;
            return this;
        }

        public SearchScope build() {
            Preconditions.checkState((this.to >= this.from ? 1 : 0) != 0, (Object)"To should be greater or equal than from");
            return new SearchScope(this.from, this.to, this.countOnly, this.sortOrder, this.hints, this.repositories, this.projectKey, this.highlights, this.details, this.timeBucket, this.user);
        }
    }
}

