/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.api;

import com.atlassian.fecru.autocomplete.AutocompleteSpecification;
import com.atlassian.fecru.search.common.api.SearchGroup;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchType;
import java.util.Map;
import java.util.TreeMap;

public class SearchResultsGroup {
    private final Map<SearchType, SearchResults<?>> results;
    private final SearchGroup group;
    private final String currentScope;

    public SearchResultsGroup(SearchGroup group, Map<SearchType, SearchResults<?>> allResults, String currentScope) {
        this.currentScope = currentScope;
        this.results = new TreeMap();
        for (Map.Entry<SearchType, SearchResults<?>> e2 : allResults.entrySet()) {
            if (e2.getKey().getGroup() != group) continue;
            this.results.put(e2.getKey(), e2.getValue());
        }
        this.group = group;
    }

    public Map<SearchType, SearchResults<?>> getResults() {
        return this.results;
    }

    public SearchGroup getType() {
        return this.group;
    }

    public AutocompleteSpecification getAutocompleteSpec() {
        return this.group.makeAutocompleteSpec(this.currentScope);
    }
}

