/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.api;

import com.atlassian.fecru.search.common.api.SearchResult;
import com.atlassian.fecru.search.common.api.SearchType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SearchResults<T extends SearchResult>
implements Iterable<T> {
    private final int totalCount;
    private final List<T> resultsExtract;
    private final SearchType searchType;

    public SearchResults(int totalCount, List<T> resultsExtract, SearchType searchType) {
        this.totalCount = totalCount;
        this.resultsExtract = Collections.unmodifiableList(resultsExtract);
        this.searchType = searchType;
    }

    public SearchResults(int totalCount, SearchType searchType) {
        this(totalCount, Collections.emptyList(), searchType);
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public Iterator<T> iterator() {
        return this.resultsExtract.iterator();
    }

    public Iterator<T> getIterator() {
        return this.iterator();
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public String toString() {
        return "SearchResults" + "{totalCount=" + this.totalCount + ", resultsExtract=" + this.resultsExtract;
    }
}

