/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.api;

import com.atlassian.fecru.autocomplete.AutocompleteSpecification;

public enum SearchGroup {
    SOURCE("Source", "all repositories"){

        @Override
        public AutocompleteSpecification makeAutocompleteSpec(String currentSelection) {
            return new AutocompleteSpecification("repository", "quicksearch-autocomplete-input", currentSelection, "json/fe/repositoryFinder.do", "All repositories", "Limit the search to a repository. This will not filter your results in '" + REVIEWS.getName() + "'.", true, "FECRU.SEARCH.changeRepository");
        }
    }
    ,
    REVIEWS("Reviews", "all projects"){

        @Override
        public AutocompleteSpecification makeAutocompleteSpec(String currentSelection) {
            return new AutocompleteSpecification("project", "quicksearch-autocomplete-input", currentSelection, "json/cru/projectFinder", "All projects", "Limit the search to a project. This will not filter your results in '" + SOURCE.getName() + "'.", true, "FECRU.SEARCH.changeProject");
        }
    }
    ,
    QUICKNAV("QuickNav", ""){

        @Override
        public AutocompleteSpecification makeAutocompleteSpec(String currentSelection) {
            throw new IllegalStateException();
        }
    };

    private final String name;
    private String unconstrainedDescription;

    private SearchGroup(String name, String unconstrainedDescription) {
        this.name = name;
        this.unconstrainedDescription = unconstrainedDescription;
    }

    public String getName() {
        return this.name;
    }

    public String getUnconstrainedDescription() {
        return this.unconstrainedDescription;
    }

    public abstract AutocompleteSpecification makeAutocompleteSpec(String var1);
}

