/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public enum QuickSearchTimeBucket {
    ANY_DATE("Any date", null),
    YESTERDAY("Yesterday", Period.hours((int)24)),
    LAST_WEEK("Last week", Period.days((int)7)),
    LAST_MONTH("Last month", Period.months((int)1)),
    LAST_YEAR("Last year", Period.years((int)1));

    private final String displayName;
    @Nullable
    private final Period period;
    public static final Map<String, String> MAP;

    private QuickSearchTimeBucket(String displayName, @Nullable Period period) {
        this.displayName = displayName;
        this.period = period;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DateTime getStartTime() {
        Preconditions.checkState((this != ANY_DATE ? 1 : 0) != 0);
        return new DateTime().minus((ReadablePeriod)this.period).dayOfYear().roundFloorCopy();
    }

    static {
        MAP = ImmutableMap.copyOf((Map)Maps.transformValues((Map)Maps.uniqueIndex(Arrays.asList(QuickSearchTimeBucket.values()), (Function)new Function<QuickSearchTimeBucket, String>(){

            public String apply(QuickSearchTimeBucket input) {
                return input.name();
            }
        }), (Function)new Function<QuickSearchTimeBucket, String>(){

            public String apply(QuickSearchTimeBucket input) {
                return input.getDisplayName();
            }
        }));
    }
}

