/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.api;

import com.atlassian.fecru.search.common.api.QuickSearchService;
import com.atlassian.fecru.search.common.api.QuickSearcher;
import com.atlassian.fecru.search.common.api.SearchResult;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fisheye.quicksearch.action.Licenses;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="quickSearchService")
@AvailableToPlugins
public class QuickSearchServiceImpl
implements QuickSearchService {
    private Map<SearchType, QuickSearcher<?>> searchers;

    @Resource
    public void setSearchers(Collection<QuickSearcher<?>> quickSearchers) {
        this.searchers = Maps.uniqueIndex(quickSearchers, (Function)new Function<QuickSearcher<?>, SearchType>(){

            public SearchType apply(QuickSearcher<?> input) {
                return input.getType();
            }
        });
    }

    @Override
    public Iterable<SearchResults<? extends SearchResult>> search(String query, SearchScope scope, Iterable<SearchType> types) {
        ImmutableList.Builder results = ImmutableList.builder();
        for (SearchType type : types) {
            QuickSearcher<?> quickSearcher = this.searchers.get((Object)type);
            if (quickSearcher == null || !Licenses.isAllowed(quickSearcher.getType())) {
                Logs.APP_LOG.warn((Object)String.format("Tried to search using %s, which is not available.", new Object[]{type}));
                continue;
            }
            Logs.APP_LOG.debug((Object)("About to search using: " + (Object)((Object)type) + " with quickSearcher: " + quickSearcher));
            SearchResults<?> searchResults = quickSearcher.search(query, scope);
            results.add(searchResults);
        }
        return results.build();
    }

    @Override
    public <T extends SearchResult> SearchResults<T> search(String query, SearchScope scope, SearchType type) {
        return (SearchResults)Iterables.getOnlyElement(this.search(query, scope, Collections.singleton(type)));
    }
}

