/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.dvcs.DvcsUtils;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import java.io.IOException;
import java.util.List;

public final class SearchUtils {
    private SearchUtils() {
    }

    public static int loadLatestRevisions(RepositoryEngine repositoryEngine, Path logicalPath, final List<FileRevision> revisions, int maxRevisions) throws DbException, IOException {
        RevisionCache<? extends ChangeSet> revisionCache = repositoryEngine.getRevisionCache();
        boolean isSvn = ScmType.SVN == repositoryEngine.getRevisionCache().getRepositoryType();
        List<Integer> headRevisionIds = revisionCache.getHeadRevisions(logicalPath, true);
        if (headRevisionIds.size() == 0 && isSvn) {
            headRevisionIds = revisionCache.getHeadRevisions(logicalPath, false);
        }
        List<Integer> topRevisions = headRevisionIds.subList(0, Math.min(maxRevisions, headRevisionIds.size()));
        revisionCache.visitRevisions(topRevisions, new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision revision) {
                revisions.add(revision);
            }
        });
        return headRevisionIds.size();
    }

    public static String getDisplayId(ScmType scmType, String csid) {
        switch (scmType) {
            case HG: 
            case GIT: {
                return DvcsUtils.truncateHash(csid);
            }
        }
        return csid;
    }
}

