/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.changesets;

import com.atlassian.fecru.search.changesets.ChangesetResult;
import com.atlassian.fecru.search.changesets.CommitMessageHighlighter;
import com.atlassian.fecru.search.common.SearchUtils;
import com.atlassian.fecru.search.common.api.QuickSearcher;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.CrossRepoSearcher;
import com.atlassian.fecru.search.common.lucene.CrossRepoSearcherState;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.searcher.PayloadIndexSearcher;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.syntax.LinkerService;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommitMessageSearcher
extends CrossRepoSearcher<ChangesetResult>
implements QuickSearcher<ChangesetResult> {
    private final CommitMessageHighlighter highlighter;
    private final CommitterUserMappingManager userMappingManager;
    private final UserManager userManager;

    @Autowired
    public CommitMessageSearcher(WikiRenderer wikiRenderer, LinkerService linkerService, RootConfig rootConfig, CrossRepLuceneIndex crossRepLuceneIndex, RepositoryManager repositoryManager, CommitterUserMappingManager userMappingManager, UserManager userManager) {
        super(SearchType.CHANGESET_COMMENTS, CrossRepLuceneIndexes.METADATA, repositoryManager, crossRepLuceneIndex);
        this.userMappingManager = userMappingManager;
        this.userManager = userManager;
        this.highlighter = new CommitMessageHighlighter(wikiRenderer, linkerService, rootConfig);
    }

    @Override
    protected Query generateQuery(String userQuery, PayloadIndexSearcher<CrossRepoSearcherState> searcher, SearchScope scope, CrossRepoSearcherState state) {
        FecruUser user;
        ImmutableListMultimap repoCommiterMappings = ImmutableMultimap.of();
        String userName = scope.getUser();
        if (!Strings.isNullOrEmpty((String)userName) && (user = this.userManager.getLicensedUser(userName)) != null) {
            if (scope.getRepositories().size() == 1) {
                String repoName = scope.getRepositories().get(0).getName();
                List<String> repoMappings = this.userMappingManager.getAllCommittersForUserInRep(repoName, userName);
                repoCommiterMappings = ImmutableListMultimap.builder().putAll((Object)repoName, repoMappings).build();
            } else {
                repoCommiterMappings = this.userMappingManager.getAllCommittersForUser(userName);
            }
            if (repoCommiterMappings.isEmpty()) {
                Logs.APP_LOG.debug((Object)("Aborting search. No committer mappings for user " + userName));
                return new BooleanQuery();
            }
        }
        return ((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetsOnly()).lastModifiedIn(scope.getTimeBucket())).optimalRepositoryQuery(state.getIncludeRepos(), state.getExcludeRepos())).withChangeSetIdOrCommentMatching(userQuery, userQuery, true).withCommitters((Multimap<String, String>)repoCommiterMappings).boostByRecency().build();
    }

    @Override
    protected SearchResults<ChangesetResult> buildSearchResults(TopDocs topDocs, SearchScope scope, PayloadIndexSearcher<CrossRepoSearcherState> searcher, String queryText, Query query) {
        ArrayList<ChangesetResult> results = new ArrayList<ChangesetResult>(scope.length());
        for (int i2 = 0; i2 < topDocs.scoreDocs.length; ++i2) {
            ScoreDoc hit = topDocs.scoreDocs[i2];
            try {
                if (!scope.inScope(i2)) continue;
                ChangesetDocInfo doc = ChangesetDocInfo.fromSearchHit(searcher, hit);
                String repository = doc.getRepository();
                RepositoryHandle handle = scope.getRepositoryForName(repository);
                if (handle == null) {
                    Logs.APP_LOG.debug((Object)("Omitting result: " + doc.getChangesetId() + ", as it came from an unknown handle " + repository));
                    continue;
                }
                String author = doc.getAuthor();
                String comment = doc.getCommitMessage();
                Date date = doc.getTimestamp();
                String displayCsid = SearchUtils.getDisplayId(handle.getCfg().getRepositoryType(), doc.getChangesetId());
                ChangesetResult result = new ChangesetResult(repository, doc.getChangesetId(), displayCsid);
                result.setAuthor(author);
                result.setDate(date);
                result.setComment(comment);
                if (scope.isHighlights()) {
                    result.setHighlightedDisplayCsid(this.highlighter.highlight(displayCsid, queryText, repository, false));
                    if (result.getComment() != null) {
                        result.setHighlightedComment(this.highlighter.highlight(comment, queryText, repository, this.highlighter.isWikiSyntax(handle, date)));
                    }
                }
                results.add(result);
                continue;
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)("Could not fetch result from index: doc ID " + hit.doc), (Throwable)e2);
            }
        }
        return new SearchResults<ChangesetResult>(topDocs.totalHits, results, this.getType());
    }

    @Override
    protected Sort getSort(SearchScope scope) {
        return scope.getSortOrder().getLuceneSort();
    }
}

