/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.changesets;

import com.atlassian.crucible.wikirenderer.CrucibleRenderContext;
import com.atlassian.fecru.search.common.highlighting.WikiHighlighter;
import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.CommitMessageSyntaxType;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.LinkerService;
import com.cenqua.fisheye.web.util.LinkerFormatter;
import java.util.Date;

final class CommitMessageHighlighter
extends WikiHighlighter {
    private final LinkerService linkerService;
    private final RootConfig rootConfig;

    public CommitMessageHighlighter(WikiRenderer wikiRenderer, LinkerService linkerService, RootConfig rootConfig) {
        super(wikiRenderer);
        this.linkerService = linkerService;
        this.rootConfig = rootConfig;
    }

    public String highlight(String comment, String queryText, String repository, boolean wikiSyntax) {
        Linker linker = this.linkerService.getRepositoryLinker(repository);
        CrucibleRenderContext context = (CrucibleRenderContext)this.wikiRenderer.setupRenderContextProperties((RenderContext)new CrucibleRenderContext(null, " ", "<br>", repository, linker, true));
        if (wikiSyntax) {
            context.pushRenderMode(RenderMode.ALL_WITH_NO_MACRO_ERRORS);
        } else {
            comment = new LinkerFormatter(linker).format(comment);
            context.pushRenderMode(RenderMode.NO_RENDER);
        }
        return super.highlight(comment, queryText, context, false);
    }

    public boolean isWikiSyntax(RepositoryHandle repository, Date commentDate) {
        RepositoryDefaultsType repositoryTypeConfig = repository.getCfg().getRepositoryDefaults();
        if (repositoryTypeConfig.isSetCommitMessageSyntax()) {
            return this.isWikiSyntax(repositoryTypeConfig.getCommitMessageSyntax(), commentDate);
        }
        return this.isWikiSyntax(this.rootConfig.getConfig().getRepositoryDefaults().getCommitMessageSyntax(), commentDate);
    }

    private boolean isWikiSyntax(CommitMessageSyntaxType commitMessage, Date commentDate) {
        return CommitMessageSyntaxType.Syntax.WIKI == commitMessage.getSyntax() && (commitMessage.getWikiSyntaxStartDate() == null || commentDate == null || commitMessage.getWikiSyntaxStartDate().getTime().before(commentDate));
    }
}

